#include <iostream>
#include <cmath>
#include <deque>
#include <map>

class Tacka{
private:
    int x;
    int y;
public:
    Tacka() : x(0), y(0) {}
    Tacka(int& x, int& y) : x(x), y(y) {}
    int& getX() { return x; }
    int& getY() { return y; }
    friend std::istream& operator>> (std::istream&, Tacka&);
};

std::istream& operator>>(std::istream& stream, Tacka& t){ return stream >> t.x >> t.y; }

class Linija{
private:
    int X;
    int Y;
public:
    Linija(Tacka& t1, Tacka& t2){
        X = t1.getY() > t2.getY() ? t1.getX() - t2.getX() : t2.getX() - t1.getX();
        Y = t1.getY() > t2.getY() ? t1.getY() - t2.getY() : t2.getY() - t1.getY();
    }
    double duzina(){ return sqrt(X * X + Y * Y); }
    double odnos(){ return (double) X / Y; }
};

int main(){
    unsigned short int n;
    std::cin >> n;

    std::deque<Tacka> pozicije;
    Tacka tempPozicija;

    for(unsigned short int i = 0; i < n; i++){
        std::cin >> tempPozicija;
        pozicije.emplace_back(tempPozicija);
    }

    std::map<double, std::deque<Linija>> linije;

    while(!pozicije.empty()){
        tempPozicija = pozicije.front();
        pozicije.pop_front();

        for(Tacka poz : pozicije){
            Linija tempLinija(tempPozicija, poz);

            if(!linije.count(tempLinija.odnos())){ 
                linije.insert({ tempLinija.odnos() , std::deque<Linija>() }); 
            }

            linije[tempLinija.odnos()].emplace_back(tempLinija);
        }
    }

    int brojTrapeza = 0;

    for(auto& x : linije){
        Linija temp = x.second.front();
        x.second.pop_front();

        for(Linija l : x.second){
            if( temp.duzina() > l.duzina() &&  temp.duzina() / 2 == l.duzina() || 
                l.duzina() > temp.duzina() &&  l.duzina() / 2 == temp.duzina() )
                brojTrapeza++;
        }
    }

    std::cout << brojTrapeza;
}