#include <bits/stdc++.h>

using namespace std;
struct Duz
{
    int indeks_a;
    int indeks_b;
    double ugao_delta_x;
    double ugao_delta_y;
    double ugao;
    double duzina;
};

struct NovaDuz
{
    int indeks;
    double duzina;
};
vector<pair<int, int>> pozicije;
Duz duzi[1500 * (1500 - 1) / 2];
int brojac=0;
double EPS = 0.00000001;
double INF = 1000000000;


double rastojanje(int x1, int y1, int x2, int y2)
{
    return sqrt(pow(x2 - x1, 2) + pow(y2 - y1, 2) * 1.0);
}

void DaLiSuParalelne(int a, int b)
{
    if(abs(duzi[a].duzina - 2 *duzi[b].duzina) < EPS || abs(duzi[b].duzina - 2 *duzi[a].duzina) < EPS)
    {
        if(abs(duzi[a].ugao - duzi[b].ugao) < EPS) brojac++;
    }
}

bool Komparator(const pair<int, int> &a, const pair<int, int> &b)
{
    if(a.first < b.first) return true;
    else if (a.first == b.first)
    {
        if(a.second < b.second) return true;
    }
    return false;
}

bool KomparatorDuziPoDuzini(const NovaDuz &a, const NovaDuz &b)
{
    if(a.duzina <= b.duzina) return true;
    return false;
}
int main()
{
    int n, x, y;

    cin >> n;


    for(int i=0; i < n; i++)
    {
        cin >> x >> y;
        pozicije.push_back(make_pair(x, y));
    }
    //n = 400;

    sort(begin(pozicije), end(pozicije), Komparator);

    vector<int> kombinacija(2);
    vector<NovaDuz> duzi_po_duzini(n * (n-1) / 2);

    int brojac_duzi = 0;

    double duzina = 0;
    double ugao = 0;
    int zbir_ukupno = 0;

    for(int i=0; i < n-1; i++)
    {
        for(int j=i+1; j < n; j++)
        {
            duzi[brojac_duzi].indeks_a = i;
            duzi[brojac_duzi].indeks_b = j;
            duzi[brojac_duzi].duzina = rastojanje(pozicije[i].first, pozicije[i].second, pozicije[j].first, pozicije[j].second);
            duzi[brojac_duzi].ugao_delta_x = pozicije[j].first - pozicije[i].first;
            duzi[brojac_duzi].ugao_delta_y = pozicije[j].second - pozicije[i].second;
            if (duzi[brojac_duzi].ugao_delta_x == 0)
            {
                duzi[brojac_duzi].ugao = INF;
            }
            else
            {
                duzi[brojac_duzi].ugao = duzi[brojac_duzi].ugao_delta_y / duzi[brojac_duzi].ugao_delta_x;
            }
            duzi_po_duzini[brojac_duzi].duzina = duzi[brojac_duzi].duzina;
            duzi_po_duzini[brojac_duzi].indeks = brojac_duzi;
            brojac_duzi++;
        }
    }

    sort(begin(duzi_po_duzini), end(duzi_po_duzini), KomparatorDuziPoDuzini);

#if 0
    for (int i = 0; i < brojac_duzi; i++)
    {
        cout << i << " = " << duzi[i].ugao << endl;
    }
    cout << "-------" << endl;
    for(NovaDuz d : duzi_po_duzini)
    {
        cout << d.indeks << "  " << d.duzina << endl;
    }
#endif

    for (int i = 0; i < brojac_duzi; i++)
    {
        int l = 0, d = brojac_duzi - 1;

        while (l <= d)
        {
            // cout << " l = " << l << "   d = " << d << endl;

            int s = (l + d) / 2;

            // if (duzi_po_duzini[s].indeks != i)
            {
                if (abs(duzi_po_duzini[s].duzina - 2 * duzi[i].duzina) <= EPS)
                {
                    if (abs(duzi[duzi_po_duzini[s].indeks].ugao - duzi[i].ugao) <= EPS)
                        brojac++;
                }
                if (duzi_po_duzini[s].duzina > EPS + 2 * duzi[i].duzina)
                {
                    d = s - 1;
                }
                else
                {
                    l = s + 1;
                }
            }
        }
    }

    cout << brojac << endl;

    return 0;
}