#include <iostream>
#include <vector>
#include <string>

using namespace std;

void broj_podsekvenci(string& x, string& y, vector < int >& granica_levo, vector < int >& granica_desno, int& indeks)
{
    int n = x.length();
    int m = y.length();

    vector < vector < long long > > dp(n+1, vector < long long >(m+1));

    for (int i = 0; i <= m; ++i)
        dp[0][i] = 0;

    for (int i = 0; i <= n; ++i)
        dp[i][0] = 1;

    for (int i = 1; i <= n; ++i)
    {
        for (int j = 1; j <= m; ++j)
        {
            if (x[i-1] == y[j-1])
                dp[i][j] = dp[i-1][j-1] + dp[i-1][j];
            else
                dp[i][j] = dp[i-1][j];
        }
    }

    for (int i = 1; i <= m; ++i)
        for (int j = 1; j <= n; ++j)
            if (dp[j][i] > 0) { granica_levo[i-1] = j-1; break; }

    granica_desno[m-1] = n-1;

    int j = m;
    for (int i = n; i > 0; --i)
        if (dp[i][j] != dp[i-1][j])
        {
            j--;
            granica_desno[j] = i-1;
        }

    int mini(n);
    for (int i = 1; i <= m; ++i)
    {
        int trenutni(0);
        for (j = granica_levo[i-1]+1; j <= granica_desno[i-1]+1; ++j)
            if (granica_levo[i-1] == granica_desno[i-1])
                {
                indeks = i-1;
                return;
                }
                else
                if (dp[j][i] != dp[j+1][i]) trenutni++;
        if (trenutni < mini)
        {
            mini = trenutni;
            indeks = i-1;
        }
    }
}

int main()
{
    string a;
    string b;
    cin >> a >> b;

    vector < int > granica_desno(a.length(), 0);
    vector < int > granica_levo(a.length(), a.length());
    int indeks(-1);
    broj_podsekvenci(a, b, granica_levo, granica_desno, indeks);

    int zbir(0);
    for (int i = granica_levo[indeks]; i <= granica_desno[indeks]; ++i)
        if (a[i] == b[indeks])
        {
            a[i] = '*';
            zbir++;
        }

    cout << zbir << '\n';
    cout << a;

    return 0;
}