using System;

namespace Takmicenje_1___3
{
    class Program
    {
        public static bool SledecaKombinacija(int[] niz, int N)
        {
            int brojac = niz.Length - 1;
            while (brojac >= 0 && niz[brojac] == N - niz.Length + brojac)
                brojac--;
            if (brojac == -1)
                return false;
            niz[brojac]++;
            for (int i = brojac + 1; i < niz.Length; i++)
                niz[i] = niz[brojac] + i - brojac;
            return true;
        }

        public struct Tacka
        {
            public int X;
            public int Y;
        }


        public static int BrojTrapeza(int[] nizI, int N, Tacka[] nizT)
        {
            int brojac = 0;
            for (int i = 0; i < nizI.Length; i++)
            {
                nizI[i] = i;
            }
            if (TrapezProvera(nizI, nizT))
            {
                brojac++;
            }
            while (SledecaKombinacija(nizI, N + 1))
            {
                if (TrapezProvera(nizI, nizT))
                {
                    brojac++;
                }
            }
            return brojac;
        }

        public static double Nagib(Tacka Tacka1, Tacka Tacka2)
        {
            if (Tacka2.X - Tacka1.X == 0) return double.MaxValue;
            return (Tacka2.Y - Tacka1.Y) / (Tacka2.X - Tacka1.X);
        }
        public static double Rastojanje(Tacka Tacka1, Tacka Tacka2)
        {
            return Math.Sqrt((Tacka2.X - Tacka1.X) * (Tacka2.X - Tacka1.X) + (Tacka2.Y - Tacka1.Y) * (Tacka2.Y - Tacka1.Y));
        }
        public static bool TrapezProvera(int[] nizI, Tacka[] nizT)
        {
            if (Nagib(nizT[nizI[0]], nizT[nizI[1]]) == Nagib(nizT[nizI[2]], nizT[nizI[3]]))
            {
                if (Rastojanje(nizT[nizI[0]], nizT[nizI[1]]) == 2 * Rastojanje(nizT[nizI[2]], nizT[nizI[3]]) ||
                    2 * Rastojanje(nizT[nizI[0]], nizT[nizI[1]]) == Rastojanje(nizT[nizI[2]], nizT[nizI[3]])) return true;
            }
            if (Nagib(nizT[nizI[0]], nizT[nizI[2]]) == Nagib(nizT[nizI[1]], nizT[nizI[3]]))
            {
                if (Rastojanje(nizT[nizI[0]], nizT[nizI[2]]) == 2 * Rastojanje(nizT[nizI[1]], nizT[nizI[3]]) ||
                    2 * Rastojanje(nizT[nizI[0]], nizT[nizI[2]]) == Rastojanje(nizT[nizI[1]], nizT[nizI[3]])) return true;
            }
            if (Nagib(nizT[nizI[0]], nizT[nizI[3]]) == Nagib(nizT[nizI[1]], nizT[nizI[2]]))
            {
                if (Rastojanje(nizT[nizI[0]], nizT[nizI[3]]) == 2 * Rastojanje(nizT[nizI[1]], nizT[nizI[2]]) ||
                    2 * Rastojanje(nizT[nizI[0]], nizT[nizI[3]]) == Rastojanje(nizT[nizI[1]], nizT[nizI[2]])) return true;
            }
            return false;
        }
        static void Main(string[] args)
        {
            int N = Convert.ToInt32(Console.ReadLine());
            string[] ulaz;
            Tacka[] nizTacaka = new Tacka[N];
            for(int i = 0; i < N; i++)
            {
                ulaz = Console.ReadLine().Split();
                nizTacaka[i].X = Convert.ToInt32(ulaz[0]);
                nizTacaka[i].Y = Convert.ToInt32(ulaz[1]);
            }
            int[] nizIndeksa = new int[4];
            Console.WriteLine(BrojTrapeza(nizIndeksa, N - 1, nizTacaka));
        }
    }
}