using System;
using System.Drawing;
using System.Collections.Generic;


namespace burh
{   
    public struct Vector{
        public double value;

        public Point strt;
        public double deg;
    }
    
    class Program
    {  
        static void PutInList(Point A, Point B,List<Vector> K){
            var deltaX = Math.Pow((B.X - A.X), 2); 
            var deltaY = Math.Pow((B.Y - A.Y), 2);
            var value = Math.Sqrt(deltaY + deltaX);
            var rad = Math.Atan2(B.X-A.X,B.Y-A.Y);
            var deg = rad * (180 / Math.PI);
            if(deg<0)deg+=180;
            if(deg>=180)deg-=180;
            Vector temp = new Vector();
            temp.value = value;
            temp.deg = deg;
            temp.strt = B;
            K.Add(temp);
        }



        static int Count(List<Vector> k,int mx,int mn){
            int cou = 0;
            for(int i = mn;i<mx&&k[i].value*2<=k[mx].value;i++){
                cou+=BingChilling(k,i,mx,k[i].value*2);
            }
            return cou;
        }

        static void Main(string[] args){
            int n = int.Parse(Console.ReadLine());
            List<Point> burh = new List<Point>();
            List<Vector> Doe = new List<Vector>();
            string[] s = Console.ReadLine().Split();
            int x1 = int.Parse(s[0]);
            int y1= int.Parse(s[1]);
            Point temp = new Point(x1,y1);
            burh.Add(temp);
            for(int i = 1;i<n;i++){
                s = Console.ReadLine().Split();
                x1 = int.Parse(s[0]);
                y1 = int.Parse(s[1]);
                temp = new Point(x1,y1);
                for(int j = 0;j<burh.Count;j++){
                    PutInList(temp,burh[j],Doe);
                }
                burh.Add(temp);
            }
            Doe.Sort((x, y) => x.deg.CompareTo(y.deg));
            int count = 0;
            int start = 0;
            int end = 0;
            double prevstate = 0;
            for(int i = 0;i<Doe.Count;i++){
                if(Doe[i].deg!=prevstate){
                    end = i-1;
                    count += Count(Doe,end,start);
                    start = i;
                    prevstate = Doe[i].deg;                  
                }
            }
            end = Doe.Count-1;
            count += Count(Doe,end,start);
            Console.WriteLine(count);
        }
        static int BingChilling(List<Vector> k, int l, int r, double x){
            if (r >= l) {
            int mid = l + (r - l) / 2;
            if (k[mid].value == x)
                return 1;
            if (k[mid].value > x)
                return BingChilling(k, l, mid - 1, x);
            return BingChilling(k, mid + 1, r, x);
            }
            return 0;
        }       
    }
}