#include <bits/stdc++.h>

typedef long long ll;
using namespace std;

double epsilon = 1e-9;

struct point {
	ll x, y;
};

struct line {
	double angle, len;
};

const double PI = 3.14159265;

inline bool operator<(const line& levi, const line& desni)
{
	if (desni.angle - desni.angle > epsilon)
		return levi.angle < desni.angle;
	else
		return levi.len < desni.len;
}

void solve()
{
	ll n;
	cin >> n;
	vector<point> points(n);
	set<line> lines;
	for (ll i = 0; i < n; i++)
	{
		ll x, y;
		cin >> x >> y;
		points[i] = {x, y};
	}
	ll ans = 0;
	for (ll i = 0; i < n-1; i++)
	{
		ll x1 = points[i].x;
		ll y1 = points[i].y;
		for (ll j = i+1; j < n; j++)
		{
			ll x2 = points[j].x;
			ll y2 = points[j].y;

			double lenSq = 1.0*(x2-x1)*(x2-x1)+(y2-y1)*(y2-y1);
			double angle = atan2(y2-y1, x2-x1) * 180 / PI;
			if (angle < -epsilon) angle += 180.0;
			line l = {angle, lenSq};
			line l1 = {angle, lenSq*4};
			line l2 = {angle, lenSq/4};
			if (lines.find(l1) != lines.end())
			{
				ans++;
			}
			if (lines.find(l2) != lines.end())
			{
				ans++;
			}
			lines.insert(l);
		}
	}
	cout << ans << "\n";
}

int main()
{
	ios_base::sync_with_stdio(false);
	cin.tie(NULL);
	solve();
	return 0;
}