#include <bits/stdc++.h>

typedef long long ll;
using namespace std;

double epsilon = 1e-9;

struct point {
	ll x, y;
};

struct line {
	double angle, len;
};

const double PI = 3.1415926535897;

inline bool operator<(const line& levi, const line& desni)
{
	if (abs(levi.angle - desni.angle) > epsilon) {
		return levi.angle < desni.angle;
	}
	return levi.len < desni.len;
}

void solve()
{
	ll n;
	cin >> n;
	vector<point> points(n);
	vector<line> lines;
	map<line,ll> lineLen;
	for (ll i = 0; i < n; i++)
	{
		ll x, y;
		cin >> x >> y;
		points[i] = {x, y};
	}
	ll ans = 0;
	for (ll i = 0; i < n-1; i++)
	{
		ll x1 = points[i].x;
		ll y1 = points[i].y;
		for (ll j = i+1; j < n; j++)
		{
			ll x2 = points[j].x;
			ll y2 = points[j].y;
			
			double lenSq = 1.0*(x2-x1)*(x2-x1)+(y2-y1)*(y2-y1);
			double angle = atan2(y2-y1, x2-x1) * 180 / PI;
			if (angle < -epsilon) angle += 180.0;
			line l = {angle, lenSq};
			if (lineLen.find(l) == lineLen.end()) {
				lineLen.insert({l, 1});
			}
			else {
				lineLen[l]++;
			}
			lines.push_back(l);
		}
	}
	sort(lines.begin(), lines.end());
	for (int i = 0; i < lines.size()-1;)
	{
		ll lineCount = lineLen[lines[i]];
		if (i + lineCount < lines.size()) {
			line newLine = lines[i+lineCount];
			ll newLineCount = lineLen[newLine];
			if (newLine.len == 4 * lines[i].len) {
				ans += (newLineCount * lineCount);
			}
			i += lineCount;
		}
		else break;
	}
	cout << ans << "\n";
}

int main()
{
	ios_base::sync_with_stdio(false);
	cin.tie(NULL);
	solve();
	return 0;
}