#include <iostream>
#include <algorithm>
#include <unordered_map>

#define MAX_N 200000
#define MAX_M 10

char T[MAX_N + 1];
int t[MAX_N + 1];
char M[MAX_M + 1];
int n, m;

struct Layer
{	
	int count = 0;
	int offset = 0;
	int indicies[MAX_N];
};
Layer layers[MAX_M];

struct MapIndicies
{
	int count;
	int indicies[MAX_M];
};
std::unordered_map<char, MapIndicies> map;

#include <thread>

int main()
{	
	std::cin >> T;
	std::cin >> M;
	
	n = strlen(T);
	m = strlen(M);

	for (int i = 0; i < m; ++i)
	{
		MapIndicies& index = map[M[i]];
		index.indicies[index.count] = i;
		++index.count;
	}

	int k = 0;
	//Filter T
	{
		for (int i = 0; i < n; ++i)
		{
			auto it = map.find(T[i]);
			if (it != map.end())
			{
				t[k] = i;
				++k;
			}
		}
	}

	for (int i = 0; i < k; ++i)
	{
		char ch = T[t[i]];
		auto it = map.find(ch);
		if (it == map.end())
			throw;		
		MapIndicies& mapIndicies = it->second;
		for (int j = 0; j < mapIndicies.count; ++j)
		{
			Layer& layer = layers[mapIndicies.indicies[j]];					
			layer.indicies[layer.count] = i;
			++layer.count;			
		}		
	}

	for (int i = 1; i < m; ++i)
	{		
		int index = layers[i - 1].indicies[0];
		while (layers[i].offset < layers[i].count && index > layers[i].indicies[layers[i].offset])
			++layers[i].offset;		
	}
	for (int i = m - 2; i >= 0; --i)
	{		
		Layer& layer = layers[i];
		int index = layers[i + 1].indicies[layers[i + 1].count - 1];
		while (layer.offset < layer.count && layer.indicies[layer.count - 1] > index)
			--layer.count;
	}

	int min = INT_MAX;
	int minLayer = -1;
	for (int i = 0; i < m; ++i)
	{
		int val = layers[i].count - layers[i].offset;
		if (val < min)
		{
			min = val;
			minLayer = i;
		}
	}

	printf("%d\n", min);

	Layer& layer = layers[minLayer];
	for (int i = layer.offset; i < layer.count; ++i)
		T[t[layer.indicies[i]]] = '*';
	
	printf(T);

	return 0;
}