#include <iostream>
#include <unordered_map>
#include <algorithm>

#define MAX_N 1500
struct Vec
{
	int x, y;
} p[MAX_N];

struct Index
{
	int a;
	int b;

	Index(int a, int b) : a(a), b(b) {}
};

struct Diff
{
	int x;
	int y;
} diff[MAX_N * (MAX_N - 1) / 2];

int m = 0;
int n;

bool Find(int x, int y, int leftBoundry)
{
	int l = leftBoundry;
	int r = m;
	int mid;	

	while (l + 1 != r)
	{
		mid = (l + r) / 2;

		Diff other = diff[mid];
		if (x < other.x || x == other.x && y < other.y)
			r = mid;
		else
			l = mid;
	}

	if (diff[l].x == x && diff[l].y == y)
		return true;
	return false;
}

int main()
{	
	std::cin >> n;

	int maxX = 0;
	int minX = INT_MAX;
	for (int i = 0; i < n; ++i)
	{
		std::cin >> p[i].x >> p[i].y;		

		if (maxX < p[i].x)
			maxX = p[i].x;
		if (minX > p[i].x)
			minX = p[i].x;

		for (int j = 0; j < i; ++j)
		{
			diff[m].x = p[i].x - p[j].x;
			diff[m].y = p[i].y - p[j].y;			

			if (diff[m].x < 0)
			{
				diff[m].x *= -1;
				diff[m].y *= -1;
			}
			else if (diff[m].x == 0 && diff[m].y < 0)
				diff[m].y *= -1;

			++m;
		}
	}

	std::sort(diff, diff + m, [](const Diff& a, const Diff& b)
		{
			return a.x < b.x || a.x == b.x && a.y < b.y;			
		});

	int xRange = maxX - minX + 1;
	int count = 0;
	
	for (int i = 0; i < m - 1; ++i)
	{
		Diff curr = diff[i];
		int otherX = curr.x * 2;
		int otherY = curr.y * 2;

		if (otherX > xRange)
			continue;
		
		if (Find(otherX, otherY, i + 1))
			++count;		
	}

	printf("%d\n", count);

	return 0;
}