using System;

namespace Prepisivaci
{
    public class Tacka
    {
        public int X { get; set; }
        public int Y { get; set; }

        public Tacka(int X, int Y)
        {
            this.X = X;
            this.Y = Y;
        }
    }

    public class Linija
    {
        public Tacka A { get; set; }
        public Tacka B { get; set; }
        public double Duzina { get; set; }
        public double Slope { get; set; }

        public Linija(Tacka A, Tacka B)
        {
            this.A = A;
            this.B = B;
            Duzina = Math.Sqrt(Math.Pow(Math.Abs(A.X - B.X), 2) + Math.Pow(Math.Abs(A.Y - B.Y), 2));
            if (A.X - B.X == 0) Slope = double.MaxValue;
            else Slope = (A.Y - B.Y) / (A.X - B.X);
        }
    }

    internal class Program
    {
        static void Main(string[] args)
        {
            int n = Convert.ToInt32(Console.ReadLine());
            Tacka[] t = new Tacka[n];
            for(int i = 0; i < n; i++)
            {
                string[] koordinate = Console.ReadLine().Split(' ');
                t[i] = new Tacka(Convert.ToInt32(koordinate[0]), Convert.ToInt32(koordinate[1]));
            }
            int m = n * (n - 1) / 2;
            Linija[] l = new Linija[m];
            int br = 0;
            for(int i = 0; i < n; i++)
            {
                for(int j = i + 1; j < n; j++)
                {
                    l[br] = new Linija(t[i], t[j]);
                    br++;
                }
            }
            int cetvorke = 0;
            for (int i = 0; i < m; i++)
            {
                for (int j = i + 1; j < m; j++)
                {
                    if (l[i].Slope == l[j].Slope && (l[i].Duzina == 2 * l[j].Duzina || l[j].Duzina == 2 * l[i].Duzina))
                    {
                        cetvorke++;
                    }
                }
            }
            Console.WriteLine(cetvorke);
        }
    }
}