#include <vector>
#include <string>
#include <iostream>
#include <unordered_set>

int Censure(std::string&, const std::string&);
void Untie();

int main() {
    Untie();
    std::string word;
    std::string horribleWord;
    std::cin >> word;
    std::cin >> horribleWord;
    std::cout << Censure(word, horribleWord) << '\n' << word << std::endl;   
    return 0;
}

void Untie() {
    std::ios_base::sync_with_stdio(false);
    std::cout.tie(nullptr);
    std::cerr.tie(nullptr);
    std::cin.tie(nullptr);
}
int Censure(std::string& word, const std::string& subsequence) {
    std::vector<std::unordered_set<int>> markers(word.size());
    int l = word.find(subsequence.front());
    int r = word.find_last_of(subsequence.back());
    int ln = 0;
    int rn = subsequence.size() - 1;
    int iteration = 0;
    std::vector<int> appearence(subsequence.size(), 0);
    std::string subl;
    std::string subr;
    while (l <= r) {
        int& point = iteration % 2 ? r : l;
        int& next = iteration % 2 ? rn : ln;
        std::string& sub = iteration % 2 ? subr : subl;
        if (word[point] == subsequence[next]) {
            sub += word[point];
            iteration % 2 ? next-- : next++;
        }
        for (int i = 0; i < sub.size(); i++) {
            if (sub[i] == word[point]) {
                int realI = iteration % 2 ? subsequence.size() - 1 - i : i;
                appearence[realI]++;
                markers[point].insert(realI);
            }
        }
        iteration % 2 ? point-- : point++;
        iteration++;
    }
    int iMin = 0;
    int min = appearence[0];
    for (int i = 1; i < subsequence.size(); i++) {
        if (appearence[i] < min) {
            min = appearence[i];
            iMin = i;
        }
    }
    for (int i = 0; i < word.size(); i++) {
        if (markers[i].find(iMin) != markers[i].end()) {
            word[i] = '*';
        }
    }
    return appearence[iMin];
}