#define _USE_MATH_DEFINES

#include <cmath>
#include <cfloat>
#include <vector>
#include <iostream>
#include <algorithm>

struct Vector2 {
    double length;
    double angle;
};
bool Colinear(const Vector2&, const Vector2&);

class Point2Int {
private:  // Fields
    int x;
    int y;
public:   // Constructors
    Point2Int(const int& = 0, const int& = 0);
public:   // Methods
    int GetX() const;
    int GetY() const;
    double Angle(const Point2Int&) const;
    double Distance(const Point2Int&) const;
    double LineAngle(const Point2Int&) const;
    Vector2 VectorNotBellowX(const Point2Int&) const;
public:   // Friends
    friend std::istream& operator >>(std::istream&, Point2Int&);
};

std::vector<Vector2> FormAllVectors(const Point2Int[], const int&);
int CountSuspicius(std::vector<Vector2>&);

int main() {
    int n;
    Point2Int seats[1500];
    std::cin >> n;
    for (int i = 0; i < n; i++) {
        std::cin >> seats[i];
    }
    auto vectors = FormAllVectors(seats, n);
    std::cout << CountSuspicius(vectors) << std::endl;
    return 0;
}

bool Colinear(const Vector2& v1, const Vector2& v2) {
    return v1.angle == v2.angle;
}
std::vector<Vector2> FormAllVectors(const Point2Int points[], const int& n) {
    std::vector<Vector2> vectors;
    vectors.reserve(n * (n - 1) / 2);
    for (int i = 0; i < n - 1; i++) {
        for (int j = i + 1; j < n; j++) {
            vectors.push_back(points[i].VectorNotBellowX(points[j]));
        }
    }
    return vectors;
}
int CountSuspicius(std::vector<Vector2>& vectors) {
    int count = 0;
    std::sort(vectors.begin(), vectors.end(), [](const Vector2& v1, const Vector2& v2) { 
        if (v1.length != v2.length) {
            return v1.length < v2.length;
        }
        return v1.angle < v2.angle;
    });
    auto it = vectors.begin();
    auto jt = it + 1;
    while (jt != vectors.end()) {
        if (2 * it->length < jt->length) {
            if (++it == jt) {
                jt++;
            }
        }
        else if (2 * it->length > jt->length) {
            jt++;
        }
        else {
            while (!Colinear(*it, *jt) && 2 * it->length == jt->length && jt != vectors.end()) {
                if (it->angle < jt->angle) {
                    if (++it == jt) {
                        jt++;
                    }
                }
                else {
                    jt++;
                }
            }
            if (2 * it->length != jt->length || jt == vectors.end()) {
                continue;
            }
            double angle = it->angle;
            double len = it->length;
            int a = 0;
            int b = 0;
            while (it->angle == angle && it->length == len) {
                it++;
                a++;
            }
            while (jt->angle == angle && jt->length == 2 * len && jt != vectors.end()) {
                jt++;
                b++;
            }
            count += a * b;
        }
    }
    return count;
}


// Point2Int
Point2Int::Point2Int(const int& x, const int& y)
: x(x), y(y) {
}

int Point2Int::GetX() const {
    return x;
}
int Point2Int::GetY() const {
    return y;
}
double Point2Int::Angle(const Point2Int& other) const {
    return std::atan2(other.y - y, other.x - x);
}
double Point2Int::Distance(const Point2Int& other) const {
    return std::sqrt((other.x - x) * (other.x - x) + (other.y - y) * (other.y - y));
}
double Point2Int::LineAngle(const Point2Int& other) const {
    double real = Angle(other);
    return (real < 0) * M_PI + real;
}
Vector2 Point2Int::VectorNotBellowX(const Point2Int& other) const {
    return Vector2{ Distance(other), LineAngle(other) };
}

std::istream& operator >>(std::istream& in, Point2Int& point) {
    in >> point.x >> point.y;
    return in;
}