#include <iostream>
#include <vector>
#include <string>
using namespace std;

int main()
{
	ios::sync_with_stdio(false);
	cin.tie(0);
	string text; cin >> text;
	string banned_word; cin >> banned_word;
	int n = text.size();
	int m = banned_word.size();

	vector<vector<int>> dp(n, vector<int>(m));
	vector<vector<pair<int, int>>> prev(n, vector<pair<int, int>>(m, { -1, -1 }));

	dp[0][0] = (text[0] == banned_word[0]);
	for (int i = 1; i < n; i++)
	{
		dp[i][0] = dp[i - 1][0] + (text[i] == banned_word[0]);
		prev[i][0] = { i - 1, 0 };
	}

	for (int i = 0; i < n; i++)
	{
		for (int j = 1; j <= min(m - 1, i); j++)
		{
			if (text[i] == banned_word[j])
			{
				int censor_last = dp[i - 1][j] + 1;
				int leave_last = dp[i - 1][j - 1];
				if (censor_last < leave_last)
				{
					dp[i][j] = censor_last;
					prev[i][j] = { i - 1, j };
				}
				else
				{
					dp[i][j] = leave_last;
					prev[i][j] = { i - 1, j - 1 };
				}
			}
			else
			{
				dp[i][j] = dp[i - 1][j];
				prev[i][j] = { i - 1, j };
			}
		}
	}

	int i = n - 1, j = m - 1;
	while (prev[i][j] != pair<int, int>(-1, -1))
	{
		auto next_state = prev[i][j];
		if (next_state.second == j && dp[i][j] == dp[next_state.first][next_state.second] + 1) text[i] = '*';
		i = next_state.first; j = next_state.second;
	}
	if (i == 0 && j == 0 && text[i] == banned_word[j]) text[i] = '*';

	cout << dp[n - 1][m - 1] << endl;
	cout << text << endl;
}