#include <iostream>
#include <algorithm>
#include <complex>
#include <vector>
#include <map>
#include <cmath>
using namespace std;

typedef complex<double> point;
#define x real()
#define y imag()

double angle(point a, point b)
{
	double first_angle = arg(a - b) * (180.0 / 3.141592653589793238463);
	double second_angle = arg(b - a) * (180.0 / 3.141592653589793238463);
	return max(arg(a - b), arg(b - a));
}

int main()
{
	int n; cin >> n;
	vector<point> points(n);
	for (int i = 0; i < n; i++)
	{
		double x_coord, y_coord; cin >> x_coord >> y_coord;
		points[i] = point(x_coord, y_coord);
	}

	long long trapezoid_cnt = 0;
	map<pair<long long, long long>, long long> angles;
	for (int i = 0; i < n; i++)
	{
		for (int j = i + 1; j < n; j++)
		{
			long long curr_angle = angle(points[i], points[j]) * 1e17;
			long long curr_distance = norm(points[i] - points[j]);
			angles[{curr_angle, curr_distance}]++;
		}
	}

	for (int i = 0; i < n; i++)
	{
		for (int j = i + 1; j < n; j++)
		{
			long long curr_angle = angle(points[i], points[j]) * 1e17;
			long long curr_distance = norm(points[i] - points[j]);
			auto it = angles.find({ curr_angle, 4 * curr_distance });
			if (it != angles.end())
			{
				trapezoid_cnt += it->second;
			}
		}
	}

	cout << trapezoid_cnt << endl;
}