#include <iostream>
#include <math.h>
#include <algorithm>
#include <limits.h>
using namespace std;

struct Tacka {
  int x;
  int y;
};

double duzina_duzi(Tacka A, Tacka B) {
  return sqrt((A.x - B.x) * (A.x - B.x) + (A.y - B.y) * (A.y - B.y));
}

double coef (Tacka A, Tacka B) {
  if (B.x - A.x == 0)
    return INT_MAX;
  return (B.y - A.y) / (B.x - A.x);
}

bool je_trapez(Tacka A, Tacka B, Tacka C, Tacka D) {
  // (A,B), (C,D)
  // (A, C), (B, D)
  // (A, D), (B, C)

  double coef_ab = coef(A, B);
  double coef_cd = coef(C, D);

  if (abs(coef_ab - coef_cd) <= 0.0001) {
    double duzina_ab = duzina_duzi(A, B);
    double duzina_cd = duzina_duzi(C, D);

    double kolicnik_ab_cd = duzina_ab / duzina_cd;
    double kolicnik_cd_ab = duzina_cd / duzina_ab;
    if ((kolicnik_ab_cd >= 2 - 0.0001 && kolicnik_ab_cd <= 2 + 0.0001 ) || (kolicnik_cd_ab >= 2-0.0001 && kolicnik_cd_ab <= 2 + 0.0001))
      return true;
  }

  double coef_ac = coef(A, C);
  double coef_bd = coef(B, D);

  if (abs(coef_ac - coef_bd) <= 0.0001) {
    double duzina_ac = duzina_duzi(A, C);
    double duzina_bd = duzina_duzi(B, D);

    double kolicnik_ac_bd = duzina_ac / duzina_bd;
    double kolicnik_bd_ac = duzina_bd / duzina_ac;
    if ((kolicnik_ac_bd >= 2 - 0.0001 && kolicnik_ac_bd <= 2 + 0.0001 ) || (kolicnik_bd_ac >= 2-0.0001 && kolicnik_bd_ac <= 2 + 0.0001))
      return true;
  }
  
  double coef_ad = coef(A, D);
  double coef_bc = coef(B, C);

  if (abs(coef_ad - coef_bc) <= 0.0001) {
    double duzina_ad = duzina_duzi(A, D);
    double duzina_bc = duzina_duzi(B, C);

    double kolicnik_ad_bc = duzina_ad / duzina_bc;
    double kolicnik_bc_ad = duzina_bc / duzina_ad;
    if ((kolicnik_ad_bc >= 2 - 0.0001 && kolicnik_ad_bc <= 2 + 0.0001 ) || (kolicnik_bc_ad >= 2-0.0001 && kolicnik_bc_ad <= 2 + 0.0001))
      return true;
  }

  return false;
}

int main() {
  Tacka tacke[1503];
  int n;

  cin >> n;

  for(int i = 0; i < n; i++) {
    cin>> tacke[i].x >> tacke[i].y;
  }

  int counter = 0;

  for(int i = 0; i < n - 3; i++) {
    for(int j = i + 1; j < n - 2; j++){
      for(int k = j + 1; k < n-1; k++){
        for(int l = k + 1; l < n; l++) {
          if (je_trapez(tacke[i], tacke[j], tacke[k], tacke[l])){
            counter++;
          }
        }
      }
    }
  }

  cout<<counter<<"\n";

  return 0;
}