using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace _D__Cenzura
{
    class Program
    {

        static int Indeks(string s, string trazeni, int n)
        {
            Match m = Regex.Match(s, "((" + Regex.Escape(trazeni) + ").*?){" + n + "}");


            if (m.Success)
            {
                return m.Groups[2].Captures[n - 1].Index;                
            }
            else
            {
                return -1;
            }
        }

        static void Main(string[] args)
        {
            string s = Console.ReadLine();
            string zabranjena = Console.ReadLine();

            int min = 0;

            if (zabranjena == "a")
            {
                s = s.Replace('a', '*');
            }
            else if (zabranjena.Length > 1 && string.IsNullOrWhiteSpace(zabranjena.Replace("a", "")))
            {
                int uk = zabranjena.Length;

                int index = Indeks(s, "a", uk);

                if (index == -1)
                {
                    Console.WriteLine(0);
                    Console.WriteLine(s);
                    return;
                }

                string s1 = s.Substring(0, index);
                string s2 = s.Substring(index, s.Length - index);

                s2 = s2.Replace('a', '*');
                

                s = s1 + s2;
            }
            else if (zabranjena == "ab")
            {
                if (!s.Contains('a') || !s.Contains('b'))
                {
                    Console.WriteLine(0);
                    Console.WriteLine(s);
                    return;
                }

                var arr = s.ToCharArray();
                Array.Reverse(arr);
                var inverse = string.Join("", arr);
                int ind1 = Indeks(inverse, "b", 1);

                int index = Indeks(s, "a", 1);

                string s1 = s.Substring(0, index);

                string s2 = s.Substring(s.Length - ind1, ind1);

                string ss = s.Substring(index, s.Length - index - ind1);

                int a = ss.Count(x => x == 'a');
                int b = ss.Count(x => x == 'b');

                if (a <= b)
                {
                    ss = ss.Replace('a', '*');
                }
                else
                {
                    ss = ss.Replace('b', '*');
                }

                s = s1 + ss + s2;

            }
            else
            {
                var arr = s.ToCharArray();
                Array.Reverse(arr);
                var inverse = string.Join("", arr);
                int ind1 = Indeks(inverse, zabranjena[zabranjena.Length-1].ToString(), 1);
                int index;

                if (zabranjena.Distinct().Count() == 1)
                {
                    index = Indeks(s, zabranjena[0].ToString(), zabranjena.Length);
                }
                else
                {
                    index = Indeks(s, zabranjena[0].ToString(), 1);
                }
                
                

                if (ind1 < 0 || index < 0)
                {
                    Console.WriteLine(0);
                    Console.WriteLine(s);
                    return;
                }

                string s1 = s.Substring(0, index);

                string s2 = s.Substring(s.Length - ind1, ind1);

                string ss = s.Substring(index, s.Length - index - ind1);
                
                int najm = int.MaxValue;
                char najmC = ' ';

                foreach (char c in zabranjena)
                {
                    int broj = ss.Count(x => x == c);
                    if (broj == 0)
                    {
                        Console.WriteLine(0);
                        Console.WriteLine(s);
                        return;
                    }
                    if (broj<najm)
                    {
                        najm = broj;
                        najmC = c;
                    }
                }

                ss = ss.Replace(najmC, '*');
                s = s1 + ss + s2;

                Console.WriteLine(najm);
                Console.WriteLine(s);
                return;

            }

            
            min = s.Count(x => x == '*');
            Console.WriteLine(min);
            Console.WriteLine(s);
        }
    }
}