#include<bits/stdc++.h>

using namespace std;

#define maxN 1501

int x[maxN];
int y[maxN];

vector<int> str;
vector<int> xi;
vector<int> yi;
vector<int> xj;
vector<int> yj;

int partition(int low, int high)
{
    int pivot = str[high];
    int i = (low - 1);

    for(int j = low; j <= high- 1; j++)
    {
        if(str[j] <= pivot)
        {
            i++;
            swap(str[i], str[j]);
            swap(xi[i], xi[j]);
            swap(xj[i], xj[j]);
            swap(yi[i], yi[j]);
            swap(yj[i], yj[j]);
        }
    }
    swap(str[i + 1], str[high]);
    swap(xi[i + 1], xi[high]);
    swap(xj[i + 1], xj[high]);
    swap(yi[i + 1], yi[high]);
    swap(yj[i + 1], yj[high]);

    return(i + 1);
}


void quickSort(int low, int high)
{
    if(low < high)
    {
        int pi = partition(low, high);

        quickSort(low, pi - 1);
        quickSort(pi + 1, high);
    }
}

int binarySearch(int l, int r, int x)
{
    if(r >= l)
    {
        int mid = l + (r - l) / 2;

        if(str[mid] == x)
            return mid;

        if(str[mid] > x)
            return binarySearch(l, mid - 1, x);

        return binarySearch(mid + 1, r, x);
    }
    return -1;
}

int main()
{
    int n;
    cin >> n;



    for(int i = 0; i < n; i++)
    {
        cin >> x[i];
        cin >> y[i];
    }

    int velcina = 0;

    for(int i = 0; i < n; i++)
    {
        for(int j = i + 1; j < n; j++)
        {
            str.push_back(((x[i] - x[j]) * (x [i] - x[j])) + ((y[i] - y[j]) * (y[i] - y[j])));
            xi.push_back(x[i]);
            yi.push_back(y[i]);
            xj.push_back(x[j]);
            yj.push_back(y[j]);

            velcina++;
        }
    }

    quickSort(0, velcina - 1);
    int brojac = 0;

    for(int i = 0; i < velcina; i++)
    {
        int poz = binarySearch(0, velcina - 1, 4 * str[i]);

        if(poz != -1)
        {
            int j = poz;

            while((j >= 0) && (str[j] == str[poz]))
            {
                int x1 = xi[i] - xj[i];
                int x2 = xi[j] - xj[j];
                int y1 = yi[i] - yj[i];
                int y2 = yi[j] - yj[j];

                if((x1 * y2) == (x2 * y1))
                {
                    brojac++;
                }

                j--;
            }

            j = poz + 1;

            while((j < velcina) && (str[j] == str[poz]))
            {
                int x1 = xi[i] - xj[i];
                int x2 = xi[j] - xj[j];
                int y1 = yi[i] - yj[i];
                int y2 = yi[j] - yj[j];

                if((x1 * y2) == (x2 * y1))
                {
                    brojac++;
                }

                j++;
            }
        }

    }




    cout << brojac << '\n';

    return 0;
}