#include <iostream>
#include <vector>
#include <tuple>
#include <cmath>
#include <map>

using namespace std;

typedef tuple<int, int> Tacka;
typedef tuple<double, Tacka, Tacka> Prava;

vector<Tacka> tacke;

bool proveriDuzine(vector<double> duzine, double d)
{
    for (int i = 0; i < duzine.size(); i++)
    {
        double trenutna = duzine[i];

        double rezultatDeljenja = trenutna / d;

        if (rezultatDeljenja == 0.5 || rezultatDeljenja == 2)
            return true;
    }

    return false;
}

int pronadjiTrapeze(int n)
{
    int brojac = 0;
    // k, d
    map<double, vector<double>> podaci;

    for (int i = 0; i < n - 1; i++)
    {
        Tacka t1 = tacke[i];
        int x1 = get<0>(t1);
        int y1 = get<1>(t1);

        for (int j = i + 1; j < n; j++)
        {
            Tacka t2 = tacke[j];
            int x2 = get<0>(t2);
            int y2 = get<1>(t2);

            double k = (double)(y2 - y1) / (double)(x2 - x1);
            if (k == -0 || k == INFINITY || k == -INFINITY)
                k = 0;

            double d = sqrt(pow((double)x2 - x1, 2) + pow((double)y2 - y1, 2));

            auto pronadjen = podaci.find(k);
            if (pronadjen != podaci.end())
            {
                // Ako postoji k vec
                vector<double> duzine = pronadjen->second;

                bool vecPostoji = proveriDuzine(duzine, d);

                if (vecPostoji)
                {
                    // cout << "Pronadjen trapez na: K=" << k << endl;
                    brojac++;
                }
            }
            else
            {
                // Ako ne postoji
                vector<double> v;
                v.push_back(d);

                podaci.insert(pair<double, vector<double>>(k, v));
            }

            // cout << "K: " << k << ", D: " << d << endl;
        }
    }

    return brojac;
}

int main()
{
    int n;
    cin >> n;

    tacke = vector<Tacka>(n);

    for (int i = 0; i < n; i++)
    {
        int x, y;
        int counter = 0;
        do
        {
            cin >> x;
            cin >> y;
            counter++;
        } while (counter != 1);

        tacke[i] = make_tuple(x, y);
    }

    int brojac = pronadjiTrapeze(n);

    cout << brojac << endl;

    return 0;
}