#include <algorithm>
#include <iostream>
#include <map>
#include <tuple>
#include <set>
#include <vector>

using namespace std;

long nzd(long a, long b) {
    if (a == 0L)
        return b;
    return nzd(b % a, a);
}

int main() {
    int n;
    cin >> n;

    using Tacka = tuple<long, long>;
    using Nagib = tuple<long, long>;

    vector<Tacka> tacke(n);
    for (int i = 0; i < n; i++) {
        long x, y;
        cin >> x >> y;
        tacke[i] = make_tuple(x, y);
    }

    sort(tacke.begin(), tacke.end());

    class Segment {
    public:
        Tacka pocetak, kraj;
        long long duzina;

        Segment(const Tacka& pocetak, const Tacka& kraj, long long duzina) {
            this->pocetak = pocetak;
            this->kraj = kraj;
            this->duzina = duzina;
        };

        Segment(long long duzina) {
            this->duzina = duzina;
        };

        bool operator<(const Segment& s) const {
            return duzina < s.duzina;
        };

        bool operator==(const Segment& s) const {
            return duzina == s.duzina;
        };
    };
    
    auto nagib = [](const Segment& const segment) {
        long dx = get<0>(segment.kraj) - get<0>(segment.pocetak);
        long dy = get<1>(segment.kraj) - get<1>(segment.pocetak);
        long d = nzd(dx, dy);
        return make_tuple(dy / d, dx / d);
    };

    // Duži razvrstavamo po nagibu da bismo brzo pretražili samo one paralelne jedno drugoj.
    map<Nagib, set<Segment>> segmenti;

    auto dodaj_segment = [&segmenti, nagib](const Tacka& tacka1, const Tacka& tacka2) {
        long dx = get<0>(tacka2) - get<0>(tacka1);
        long dy = get<1>(tacka2) - get<1>(tacka1);
        Segment segment(tacka1, tacka2, (long long) dx * dx + (long long) dy * dy);
        segmenti[nagib(segment)].insert(segment);
    };

    for (int i = 0; i < n - 1; i++)
        for (int j = i + 1; j < n; j++)
            dodaj_segment(tacke[i], tacke[j]);

    int broj_prepisivaca = 0;

    auto pretrazi_segmente = [&broj_prepisivaca](const set<Segment>& segmenti) {
        for (const Segment& segment : segmenti)
            if (segmenti.find(Segment(segment.duzina << 2)) != segmenti.end())
                broj_prepisivaca++;
    };

    for (auto it = segmenti.begin(); it != segmenti.end(); it++)
        pretrazi_segmente(it->second);

    cout << broj_prepisivaca << endl;
    return 0;
}