#include <algorithm>
#include <iostream>
#include <map>
#include <tuple>
#include <set>
#include <vector>

using namespace std;

long nzd(long a, long b) {
    if (a == 0L)
        return b;
    return nzd(b % a, a);
}

int main() {
    int n;
    cin >> n;

    using Tacka = tuple<long, long>;
    using Nagib = tuple<long, long>;

    vector<Tacka> tacke(n);
    for (int i = 0; i < n; i++) {
        long x, y;
        cin >> x >> y;
        tacke[i] = make_tuple(x, y);
    }

    sort(tacke.begin(), tacke.end());
    
    // Duži razvrstavamo po nagibu da bismo brzo pretražili samo one paralelne jedno drugoj.
    map<Nagib, set<long long>> segmenti;

    auto dodaj_segment = [&segmenti](const Tacka& tacka1, const Tacka& tacka2) {
        long dx = get<0>(tacka2) - get<0>(tacka1);
        long dy = get<1>(tacka2) - get<1>(tacka1);
        long d = nzd(dx, dy);
        segmenti[make_tuple(dy / d, dx / d)].insert((long long)dx * dx + (long long)dy * dy);
    };

    for (int i = 0; i < n - 1; i++)
        for (int j = i + 1; j < n; j++)
            dodaj_segment(tacke[i], tacke[j]);

    int broj_prepisivaca = 0;

    auto pretrazi_segmente = [&broj_prepisivaca](const set<long long>& duzine) {
        for (long long duzina : duzine)
            if (duzine.find(duzina << 2) != duzine.end())
                broj_prepisivaca++;
    };

    for (auto it = segmenti.begin(); it != segmenti.end(); it++)
        pretrazi_segmente(it->second);

    cout << broj_prepisivaca << endl;
    return 0;
}