#include <bits/stdc++.h>

using namespace std;

#define pii pair<int,int>
#define ll long long
#define s second
#define f first

struct Vec2 {
	double x, y;

	Vec2() : x(0), y(0) {                        // Calling the constructor without any parameters creates the zero vector
	}

	Vec2(double _x, double _y) : x(_x), y(_y) {
	}

	Vec2 operator +(const Vec2& o) const {       // Vector addition
		return {x + o.x, y + o.y};
	}

	Vec2 operator -(const Vec2& o) const {       // Vector subtraction
		return {x - o.x, y - o.y};
	}

	Vec2 operator -() const {                    // Inverse
		return {-x, -y};
	}

	Vec2 operator *(const double c) const {      // Scaling by a constant
		return {c*x, c*y};
	}

	Vec2 operator /(const double c) const {      // Division
		return {x/c, y/c};
	}

	double operator *(const Vec2& o) const {     // Scalar product
		return x*o.x + y*o.y;
	}

	double operator ^(const Vec2& o) const {     // Vector product (its length)
		return x*o.y - y*o.x;
	}

	Vec2 operator ~() const {                    // Orthogonal vector
		return {-y, x};
	}

	double length() const {                      // Length
		return sqrt(x*x + y*y);
	}

	double lengthSqr() {                         // Length squared
		return x*x + y*y;
	}

	Vec2 normalized() const {                    // Normalized vector
		double l = length();
		return {x/l, y/l};
	}
};

Vec2 readVec2(istream& is) {
	double x, y;
	is >> x >> y;
	return Vec2(x, y);
}

ostream& operator <<(ostream& os, const Vec2& v) {
	os << "(" << v.x << ", " << v.y << ")";
	return os;
}

struct Line{
  const Vec2 p1, p2;
  Line() : p1(), p2() {
  }
  Line(const Vec2& _p1, const Vec2& _p2) : p1(_p1), p2(_p2){
  }
  Vec2 intersection(const Line& l2) const{
    Line l1 = *(this);
    double x1 = l1.p1.x;
    double x2 = l1.p2.x;
    double x3 = l2.p1.x;
    double x4 = l2.p2.x;
    double y1 = l1.p1.y;
    double y2 = l1.p2.y;
    double y3 = l2.p1.y;
    double y4 = l2.p2.y;
    double D = ( (x1 - x2) * (y3 - y4) ) - ( (y1 - y2) * (x3 - x4));
    if(!D){return Vec2();}      // prave su paralelne
    double x = ( ( (x1 * y2) - (y1 * x2) ) * (x3 - x4) ) - ( (x1 - x2) * ( (x3 * y4) - (y3 * x4) ) );
    double y = ( ( (x1 * y2) - (y1 * x2) ) * (y3 - y4) ) - ( (y1 - y2) * ( (x3 * y4) - (y3 * x4) ) );
    x /= D;
    y /= D;
    return Vec2(x, y);
  }
  bool do_segments_intersect(const Line& l2) const{
    Line l1 = *(this);
    Vec2 p = l1.p1;
    Vec2 r = l1.p2 - l1.p1;
    Vec2 q = l2.p1;
    Vec2 s = l2.p2 - l2.p1;
    double t = (q - p) ^ s / (r ^ s);
    double u = (q - p) ^ r / (r ^ s);
    if(((r ^ s) == 0) && (((q - p) ^ r) == 0)){return true;}
    if(((r ^ s) != 0) && 0 <= t && t <= 1 && 0 <= u && u <= 1){return true;}
    return false;
  }
  bool does_line_intersect_segment(const Line& l2) const{
    Line l1 = *(this);
    Vec2 p = l1.p1;
    Vec2 r = l1.p2 - l1.p1;
    Vec2 q = l2.p1;
    Vec2 s = l2.p2 - l2.p1;
    double u = (q - p) ^ r / (r ^ s);
    if(((r ^ s) == 0) && (((q - p) ^ r) == 0)){return true;}
    if(((r ^ s) != 0) && 0 <= u && u <= 1){return true;}
    return false;
  }
  void side(const Vec2& p) const{
    Line l = *(this);
    double val = ( ( (l.p2.x - l.p1.x) * (p.y - l.p1.y) ) - ( (l.p2.y - l.p1.y) * (p.x - l.p1.x) ) );
    if ( val > 0){cout << "Levo" << endl;}
    else if (val == 0){cout << "Na pravi" << endl;}
    else{cout << "Desno" << endl;}
  }
  double distance(const Vec2& p){
    Line l = *(this);
    Vec2 q = l.p1;
    Vec2 r = l.p2 - l.p1;
    double t = (p - q) * (r) / (r * r);
    t = min(max(t, 0.0), 1.0);
    return sqrt((q - p + (r * t) ) * (q - p + (r * t)));
  }
};

Line readLine(istream& is){
  double x1, y1, x2, y2;
  is >> x1 >> y1 >> x2 >> y2;
  return Line(Vec2(x1, y1), Vec2(x2, y2));
}

ostream& operator <<(ostream& os, const Line& l){
  os << "(" << l.p1 << "," << l.p2 << ")" << endl;
  return os;
}

ll n, ans;
Vec2 a[1505];
map<pair<double, double>, int> mp;
map<double, int> mp1;

int main(){
  cin >> n;
  for(int i = 0; i < n; ++i){
    a[i] = readVec2(cin);
  }
  for(int i = 0; i < n; ++i){
    for(int j = i + 1; j < n; ++j){
     if(i == j){continue;}
     Vec2 x = a[i] - a[j];
     double lensqr = x.lengthSqr();
     if(a[i].x == a[j].x){
        ++mp1[(a[i].y - a[j].y) * (a[i].y - a[j].y)];
        continue;
     }
     double k = (a[i].y - a[j].y) / (a[i].x - a[j].x);
     //cout << a[i] << " " << a[j] << "  " << lensqr << " " << k << endl;
     ++mp[{k, lensqr}];
    }
  }
  for(auto it = mp.begin(); it != mp.end(); ++it){
    auto p = *it;
   // cout << p.f.f << " " << p.f.s << " " << p.s << endl;
    ans += mp[make_pair(p.f.f, 4 * p.f.s)];
  }
  for(auto it = mp1.begin(); it != mp1.end(); ++it){
    auto p = *it;
    //cout << p.f << " " << p.s << endl;
    ans += mp1[4 * p.f];
  }
  cout << ans << endl;
  return 0;
}