#include <bits/stdc++.h>

using namespace std;

#define pii pair<int,int>
#define ll long long
#define s second
#define f first

struct Vec2 {
	double x, y;

	Vec2() : x(0), y(0) {                        // Calling the constructor without any parameters creates the zero vector
	}

	Vec2(double _x, double _y) : x(_x), y(_y) {
	}

	Vec2 operator +(const Vec2& o) const {       // Vector addition
		return {x + o.x, y + o.y};
	}

	Vec2 operator -(const Vec2& o) const {       // Vector subtraction
		return {x - o.x, y - o.y};
	}

	Vec2 operator -() const {                    // Inverse
		return {-x, -y};
	}

	Vec2 operator *(const double c) const {      // Scaling by a constant
		return {c*x, c*y};
	}

	Vec2 operator /(const double c) const {      // Division
		return {x/c, y/c};
	}

	double operator *(const Vec2& o) const {     // Scalar product
		return x*o.x + y*o.y;
	}

	double operator ^(const Vec2& o) const {     // Vector product (its length)
		return x*o.y - y*o.x;
	}

	Vec2 operator ~() const {                    // Orthogonal vector
		return {-y, x};
	}

	double length() const {                      // Length
		return sqrt(x*x + y*y);
	}

	double lengthSqr() {                         // Length squared
		return x*x + y*y;
	}

	Vec2 normalized() const {                    // Normalized vector
		double l = length();
		return {x/l, y/l};
	}
};

Vec2 readVec2(istream& is) {
	double x, y;
	is >> x >> y;
	return Vec2(x, y);
}

ostream& operator <<(ostream& os, const Vec2& v) {
	os << "(" << v.x << ", " << v.y << ")";
	return os;
}

ll n, ans;
Vec2 a[1505];
map<pair<double, double>, int> mp;
map<double, int> mp1;

int main(){
  ios_base::sync_with_stdio(false);
  cin.tie(0);
  cout.tie(0);
  cin >> n;
  for(int i = 0; i < n; ++i){
    a[i] = readVec2(cin);
  }
  for(int i = 0; i < n; ++i){
    for(int j = i + 1; j < n; ++j){
     if(i == j){continue;}
     Vec2 x = a[i] - a[j];
     double lensqr = x.lengthSqr();
     if(a[i].x == a[j].x){
        ++mp1[(a[i].y - a[j].y) * (a[i].y - a[j].y)];
        continue;
     }
     double k = (a[i].y - a[j].y) / (a[i].x - a[j].x);
     //cout << a[i] << " " << a[j] << "  " << lensqr << " " << k << endl;
     ++mp[{k, lensqr}];
    }
  }
  for(auto it = mp.begin(); it != mp.end(); ++it){
    auto p = *it;
   // cout << p.f.f << " " << p.f.s << " " << p.s << endl;
    ans += mp[make_pair(p.f.f, 4 * p.f.s)];
  }
  for(auto it = mp1.begin(); it != mp1.end(); ++it){
    auto p = *it;
    //cout << p.f << " " << p.s << endl;
    ans += mp1[4 * p.f];
  }
  cout << ans << endl;
  return 0;
}