#include <iostream>
#include <algorithm>

int main()
{
	std::string input;
	std::string censor;

	std::getline(std::cin, input);
	std::cin >> censor;

	if(censor.length() > input.length())
	{
		std::cout << "0\n" << input << "\n";
		return 0;
	}

	int l_count[26] = {0};
	int l_count_allowed[26] = {0};

	for(const auto chr : input)
	{
		l_count[static_cast<int>(chr) - 97]++;
	}
	
	int min = -1;
	int min_ind = -1;
	
	for(const auto chr : censor)
	{
		int index = static_cast<int>(chr - 97);
		l_count_allowed[index] = l_count[index];
	}

	for(int i = 0; i < 26; i++)
	{
		if(l_count_allowed[i] == 0)
			continue;

		if(min == -1 || l_count_allowed[i] < min)
		{
			min = l_count_allowed[i];
			min_ind = i;
		}
	}

	std::replace(input.begin(), input.end(), static_cast<char>(min_ind + 97), '*');

	std::cout << l_count_allowed[min_ind] << "\n" << input << "\n";
	
	return 0;
}