#include <iostream>
#include <vector>
#include <limits>

struct position
{
	int x;
	int y;
	bool checked;

	position(int x, int y) : x {x}, y{y}, checked{false} {}
};

double slope(position p1, position p2)
{
	if(p1.x == p2.x)
		return std::numeric_limits<int>::max();

	return (p2.y - p1.y)/(p2.x - p1.x);
}

double dist(position p1, position p2)
{
	return (p2.x - p1.x)*(p2.x - p1.x) + (p2.y - p1.y)*(p2.y - p1.y); 
}

int main()
{
	int n;
	std::vector<position> positions;

	std::cin >> n;

	for(int i = 0; i < n; i++)
	{
		int x, y;
		std::cin >> x >> y;

		positions.emplace_back(x, y);
	}

	if(n != 4)
	{
		if(n < 4)
			std::cout << "0\n";
		return 0;
	}

	int count = 0;
	if(slope(positions[0], positions[1]) == slope(positions[2], positions[3]))
	{
		double distAB = dist(positions[0], positions[1]);
		double distCD = dist(positions[2], positions[3]);

		if((distAB >= 2 * distCD) || (distCD >= 2 * distAB))
			count++;
	}
	
    if(slope(positions[0], positions[2]) == slope(positions[1], positions[3]))
    {
        double distAB = dist(positions[0], positions[2]);
        double distCD = dist(positions[1], positions[3]);

        if((distAB >= 2 * distCD) || (distCD >= 2 * distAB))
            count++;
    }

    if(slope(positions[0], positions[3]) == slope(positions[1], positions[2]))
    {
        double distAB = dist(positions[0], positions[3]);
        double distCD = dist(positions[1], positions[2]);

        if((distAB >= 2 * distCD) || (distCD >= 2 * distAB))
            count++;
    }
	
	std::cout << count << "\n";

	return 0;
}