#include <iostream>
#include <map>
#include <string>

using namespace std;
const long long INF = 1000000000000000000;

class Pair
{
public:
	double k;
	long long l;
	Pair(double k1, long long l1) : k(k1), l(l1) {}
};

class ComparePairs
{
public:
	bool operator()(const Pair& p1, const Pair& p2) const
	{
		if (p1.l == p2.l)
			return p1.k < p2.k;
		return p1.l < p2.l;
	}
};


int main()
{
	ios_base::sync_with_stdio(false);
	cin.tie(0);

	int n;
	cin >> n;

	int xs[n];
	int ys[n];
	map<Pair, int, ComparePairs> mapaDuzi;

	for (int i = 0; i < n; ++i)
		cin >> xs[i] >> ys[i];

	for (int i = 0; i < n; ++i)
		for (int j = i + 1; j < n; ++j)
		{
			long long dist_s;
			double k;
			if (xs[i] == xs[j])
			{
				dist_s = (ys[j] - ys[i]) * (ys[j] - ys[i]);
				k = INF;
			}
			else
			{
				dist_s = (xs[i] - xs[j]) * (xs[i] - xs[j]) + (ys[i] - ys[j]) * (ys[i] - ys[j]);
				k = (ys[j] - ys[i]) / (xs[j] - xs[i]);
			}
			mapaDuzi[Pair(k, dist_s)] += 1;
		}

	int res_count = 0;
	for (pair<Pair, int> x : mapaDuzi)
	{
		double k = x.first.k;
		long long l = x.first.l;
		int count = x.second;
		Pair temp = Pair(k, 4 * l);
		if (mapaDuzi.count(temp) != 0)
			res_count += mapaDuzi[temp] * count;
	}

	cout << res_count << endl;

}