using System;

namespace Prepisivaci
{
    class Program
    {
        struct Tacka 
        {
            public int x;
            public int y;
            public Tacka(int x, int y) 
            {
                this.x = x;
                this.y = y;
            }
        }

        static double duzina(int x1, int y1, int x2, int y2) 
        {
            return Math.Sqrt(Math.Abs(x1 - x2) * Math.Abs(x1 - x2) + Math.Abs(y1 - y2) * Math.Abs(y1 - y2));
        }

        static int proveri(Tacka[] tacke, int i1, int i2, int i3, int i4) 
        {
            if((double)Math.Abs(tacke[i1].x - tacke[i2].x) / Math.Abs(tacke[i1].y - tacke[i2].y) == (double)Math.Abs(tacke[i3].x - tacke[i4].x) / Math.Abs(tacke[i3].y - tacke[i4].y)) 
            {
                double a = duzina(tacke[i1].x, tacke[i1].y, tacke[i2].x, tacke[i2].y);
                double b = duzina(tacke[i3].x, tacke[i3].y, tacke[i4].x, tacke[i4].y);
                if (a == 2 * b || b == 2 * a) return 1;
                return 0;
            }
            else if((double)Math.Abs(tacke[i1].x - tacke[i3].x) / Math.Abs(tacke[i1].y - tacke[i3].y) == (double)Math.Abs(tacke[i2].x - tacke[i4].x) / Math.Abs(tacke[i2].y - tacke[i4].y)) 
            {
                double a = duzina(tacke[i1].x, tacke[i1].y, tacke[i3].x, tacke[i3].y);
                double b = duzina(tacke[i2].x, tacke[i2].y, tacke[i4].x, tacke[i4].y);
                if (a == 2 * b || b == 2 * a) return 1;
                return 0;
            }
            else if((double)Math.Abs(tacke[i1].x - tacke[i4].x) / Math.Abs(tacke[i1].y - tacke[i4].y) == (double)Math.Abs(tacke[i2].x - tacke[i3].x) / Math.Abs(tacke[i2].y - tacke[i3].y)) 
            {
                double a = duzina(tacke[i1].x, tacke[i1].y, tacke[i4].x, tacke[i4].y);
                double b = duzina(tacke[i2].x, tacke[i2].y, tacke[i3].x, tacke[i3].y);
                if (a == 2 * b || b == 2 * a) return 1;
                return 0;
            }
            return 0;
        }
        static void kombinacije(Tacka[] tacke, int[] indeksi, int s, int e, int i, int k, ref int brojac)
        {
            if (i == k)
            {
                brojac += proveri(tacke, indeksi[0], indeksi[1], indeksi[2], indeksi[3]);
                return;
            }

            for(int j = s; j <= e && e - j + 1 >= k - i; j++) 
            {
                indeksi[i] = j;
                kombinacije(tacke, indeksi, j + 1, e, i + 1, k, ref brojac);
            }
        }

        static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            int brojac = 0;
            Tacka[] tacke = new Tacka[n];
            string[] ulaz;
            for(int i = 0; i < n; i++) 
            {
                ulaz = Console.ReadLine().Split();
                tacke[i] = new Tacka(int.Parse(ulaz[0]), int.Parse(ulaz[1]));
            }

            int[] indeksi = new int[4];
            kombinacije(tacke, indeksi, 0, n - 1, 0, 4, ref brojac);
            Console.WriteLine(brojac);
        }
    }
}