#include <iostream>
#include <math.h>
#include <vector>
#include <map>
#include <utility>
#include <algorithm>
#define mymap map<double, vector<line> > 

using namespace std;

struct point {
	int x;
	int y;
};

struct line {
	point p1;
	point p2; 
	double length;
};

double Calculatelength(point& p1, point& p2) {
	return sqrt(pow(p1.x - p2.x, 2) + pow(p1.y - p2.y, 2));
}

int lb(vector<line>& vect, double lensrc) {
	int l = 0, d = vect.size() - 1;
	int index = vect.size();
	while (l <= d) {
		int median = l + (d - l) / 2;
		if (vect[median].length == lensrc) {
			index = median;
			d = median - 1;
		}
		else if (vect[median].length > lensrc)
			d = median - 1;
		else
			l = median + 1;
	}
	return index;
}

int ub(vector<line>& vect, double lensrc) {
	int l = 0, d = vect.size() - 1;
	int index = -2;
	while (l <= d) {
		int median = l + (d - l) / 2;
		if (vect[median].length == lensrc) {
			index = median;
			l = median + 1;
		}
		else if (vect[median].length > lensrc)
			d = median - 1;
		else
			l = median + 1;
	}
	return index + 1;
}

int main() {
	ios_base::sync_with_stdio(false);

	int n; cin >> n;
	int i, j;
	int total = 0;
	vector<point> points(n);
	vector<line> xs;
	mymap parallel_lines;
	for (i = 0; i < n; i++) 
		cin >> points[i].x >> points[i].y;
	for (i = 0; i < n; i++) {
		for (j = i + 1; j < n; j++) {
			if (points[j].x != points[i].x) {
				double m = (double)(points[j].y - points[i].y) / (points[j].x - points[i].x);
				parallel_lines[m].push_back({ points[i], points[j], Calculatelength(points[i], points[j]) });
			}
			else
				xs.push_back({ points[i], points[j], fabs(points[i].y - points[j].y) });
		}
	}
	mymap::iterator itr;
	for (itr = parallel_lines.begin(); itr != parallel_lines.end(); itr++) {
		if (itr->second.size() > 1) {
			vector<line> tmp = itr->second;
			sort(tmp.begin(), tmp.end(),
				[](const line& l1, const line& l2) {
					return l1.length < l2.length;
				});
			for (i = 0; i < tmp.size() - 1; i++) {
				int l_bound = lb(tmp, tmp[i].length * 2);
				int u_bound = ub(tmp, tmp[i].length * 2);
				if (u_bound - l_bound > 0)
					total += u_bound - l_bound;
			}
		}
	}
	sort(xs.begin(), xs.end(),
		[](const line& l1, const line& l2) {
			return l1.length < l2.length;
		});
	for (i = 0; i < xs.size() - 1; i++) {
		int l_bound = lb(xs, xs[i].length * 2);
		int u_bound = ub(xs, xs[i].length * 2);
		if (u_bound - l_bound > 0)
			total += u_bound - l_bound;
	}
	cout << total;
	return 0;
}