using System;

namespace Takmicenje_27._11._2021_
{
    class Program
    {
        struct Tacka
        {
            public int x;
            public int y;
        }
        struct Prava
        {
            public Tacka pocetak;
            public Tacka kraj;
            public double duzina_prave;
        }
        static double Nagib(Tacka tacka, Tacka tacka2)
        {
            if (tacka2.x - tacka.x == 0) return int.MaxValue; 
            return ((tacka2.y - tacka.y) / (tacka2.x - tacka.x));
        }
        static bool Paralelne(Tacka tacka1, Tacka tacka2, Tacka tacka3, Tacka tacka4)
        {
            if (Nagib(tacka1, tacka2) == Nagib(tacka3, tacka4)) return true;
            else return false;
        }
        static bool DuploVeca(double rastojanje1, double rastojanje2)
        {
            if (rastojanje1 == 2 * rastojanje2 || rastojanje2 == 2 * rastojanje1) return true;
            else return false;
        }
        static double Rastojanje(Tacka tacka1, Tacka tacka2)
        {
            return Math.Sqrt((tacka1.x - tacka2.x) * (tacka1.x - tacka2.x) + (tacka1.y - tacka2.y) * (tacka1.y - tacka2.y));
        }
        static void Main(string[] args)
        {
            int n = Convert.ToInt32(Console.ReadLine());
            string[] s;
            Tacka[] tacke = new Tacka[n];

            for (int i = 0; i < n; i++)
            {
                s = Console.ReadLine().Split();
                tacke[i].x = Convert.ToInt32(s[0]);
                tacke[i].y = Convert.ToInt32(s[1]);
            }
            Prava[] prave = new Prava[(n * (n - 1)) / 2];
            int brojac = 0;
            for (int i = 0; i < n; i++)
            {
                for (int k = i + 1; k < n; k++)
                {
                    prave[brojac].pocetak = tacke[i];
                    prave[brojac].kraj = tacke[k];
                    prave[brojac].duzina_prave = Rastojanje(tacke[i], tacke[k]);
                    brojac++;
                }
            }
            int kandidat = 0;
            for (int i = 0; i < brojac; i++)
            {
                for (int k = i + 1; k < brojac; k++)
                {
                    if (Paralelne(prave[i].pocetak, prave[i].kraj, prave[k].pocetak, prave[k].kraj) && DuploVeca(prave[i].duzina_prave, prave[k].duzina_prave))
                    {
                        //Console.WriteLine(i + " " + k + " " + prave[i].duzina_prave + " " + prave[k].duzina_prave);
                        kandidat++;
                    }
                }
            }
            Console.WriteLine(kandidat);
        }
    }
}