using System;

namespace Takprog___cenzura
{
    class Program
    {
        static int[] Najsira_rec(string t, string s)
        {
            int[] indeksi = new int[s.Length];
            for (int i = 0; i < indeksi.Length; i++)
                indeksi[i] = -1;
            int l = 0, d = t.Length - 1;
            for (int i = 0, j = s.Length - 1; i <= j; i++, j--)
            {
                for (int k = l; k <= d && k <t.Length; k++)
                {
                    if (s[i] == t[k])
                    {
                        indeksi[i] = k;
                        l = k + 1;
                        break;
                    }
                }
                if (i == j) continue;
                for (int k = d; d > l && k >= 0; k--)
                {
                    if (s[j] == t[k])
                    {
                        indeksi[j] = k;
                        d = k - 1;
                        break;
                    }
                }
            }
            return indeksi;
        }
        static int Najredje_slovo(int[] niz)
        {
            int min = niz[niz.Length - 1];
            int id = niz.Length - 1;
            for (int i = niz.Length - 2; i >= 0; i--)
                if (niz[i] < min)
                {
                    min = niz[i];
                    id = i;
                }
            return id;
        }
        static bool Postoji_rec(int[] indeksi)
        {
            foreach (int i in indeksi)
                if (i == -1) return false;
            return true;
        }
        static void Izbaci_sl(ref string t, int id, int[] indeksi)
        {
            t = t.Remove(indeksi[id], 1);
            t = t.Insert(indeksi[id], "*");
        }
        static int Cenzura(ref string t1, string s)
        {   
            // ucestalost slova
            int[] duplikati = new int[s.Length];
            for (int i = 0; i < s.Length; i++)
            {
                for (int j = 0; j < t1.Length; j++)
                {
                    if (t1[j] == s[i]) duplikati[i]++;
                }
            }

            int[] id_najsire = Najsira_rec(t1, s);

            int brojac = 0;
            while(Postoji_rec(id_najsire))
            {
                Izbaci_sl(ref t1, Najredje_slovo(duplikati), id_najsire);
                brojac++;
                id_najsire = Najsira_rec(t1, s);
            }
            return brojac;
        }
        static void Main(string[] args)
        {
            string tekst = Console.ReadLine();
            string rec = Console.ReadLine();
            Console.WriteLine(Cenzura(ref tekst, rec));
            Console.WriteLine(tekst);
        }
    }
}