using System;

namespace Takprog___prepisivaci
{
    class Program
    {
        struct Tacka
        {
            public int x;
            public int y;
        }
        struct Prava
        {
            public Tacka t1;
            public Tacka t2;
            public double r;
        }
        static double Rastojanje(Prava p)
        {
            Tacka t1 = p.t1;
            Tacka t2 = p.t2;
            return Math.Sqrt(Math.Pow(t1.x - t2.x, 2) + Math.Pow(t1.y - t2.y, 2));
        }
        static bool Paralelne_str_duzine(Prava p1, Prava p2)
        {
            if ((p1.t1.x == p2.t1.x && p1.t1.y == p2.t1.y) ||
                (p1.t1.x == p2.t2.x && p1.t1.y == p2.t2.y) ||
                (p1.t2.x == p2.t1.x && p1.t2.y == p2.t1.y) ||
                (p1.t2.x == p2.t2.x && p1.t2.y == p2.t2.y)) return false;

            double c1 = p1.r;
            double c2 = p2.r;
            double a1 = Math.Abs(p1.t1.y - p1.t2.y);
            double a2 = Math.Abs(p2.t1.y - p2.t2.y);

            if (a1 == 0 && a2 == 0) return true;
            if (a1 == 0 || a2 == 0) return false;
            if (c2 / c1 == a2 / a1) return true;
            return false;
        }
        static int Broj_trapeza(Tacka[] tacke)
        {
            Prava[] prave = new Prava[tacke.Length * (tacke.Length - 1) / 2];
            int brojac = 0;
            // generisanje kombinacija tacaka
            for (int i = 0; i < prave.Length; i++)
            {
                for (int j = i + 1; j < tacke.Length; j++)
                {
                    prave[brojac].t1.x = tacke[i].x;
                    prave[brojac].t1.y = tacke[i].y;
                    prave[brojac].t2.x = tacke[j].x;
                    prave[brojac].t2.y = tacke[j].y;

                    // odredjivanje duzine prave
                    prave[brojac].r = Rastojanje(prave[brojac]);
                    brojac++;
                }
            }
            Array.Sort(prave, (a, b) => {
                return a.r.CompareTo(b.r);
            });

            int trapezi = 0;
            for (int i = 0; i < prave.Length; i++)
            {
                for (int j = i + 1; j < prave.Length && prave[j].r <= prave[i].r * 2; j++)
                {
                    if (prave[j].r == prave[i].r * 2 && Paralelne_str_duzine(prave[i], prave[j])) trapezi++;
                }
            }
            return trapezi;
        }
        static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            Tacka[] tacke = new Tacka[n];
            string[] s;
            for (int i = 0; i < tacke.Length; i++)
            {
                s = Console.ReadLine().Split();
                tacke[i].x = Convert.ToInt32(s[0]);
                tacke[i].y = Convert.ToInt32(s[1]);
            }
            Console.WriteLine(Broj_trapeza(tacke));
        }
    }
}