using System;
using System.Collections.Generic;

namespace Takmicenje
{
    class Program
    {
        static void Main()
        {
            int n = int.Parse(Console.ReadLine());
            int[] x = new int[n];
            int[] y = new int[n];
            for (int i = 0; i < n; i++)
            {
                string[] s = Console.ReadLine().Split();
                x[i] = int.Parse(s[0]);
                y[i] = int.Parse(s[1]);
            }

            Console.WriteLine(Zadatak(n, x, y));
            Console.ReadLine();
        }

        public static int Zadatak(int n, int[] x, int[] y)
        {
            int brojSumnjivihCetvorki = 0;

            for (int i = 0; i < n; i++)
            {
                for (int j = i + 1; j < n; j++)
                {
                    for (int k = j + 1; k < n; k++)
                    {
                        for (int l = k + 1; l < n; l++)
                        {
                            if (DaLiJeSumnjivTrapez(x[i], x[j], x[k], x[l], y[i], y[j], y[k], y[l]))
                            {
                                brojSumnjivihCetvorki++;
                            }
                        }
                    }
                }
            }

            return brojSumnjivihCetvorki;
        }

        public static bool DaLiJeTrapez(int x1, int x2, int x3, int x4, int y1, int y2, int y3, int y4)
        {
            bool paralelne12sa34 = DaLiSuDuziParalelne(x1, x2, x3, x4, y1, y2, y3, y4);
            bool paralelne13sa24 = DaLiSuDuziParalelne(x1, x3, x2, x4, y1, y3, y2, y4);
            bool paralelne14sa23 = DaLiSuDuziParalelne(x1, x4, x2, x3, y1, y4, y2, y3);
            if (paralelne12sa34 || paralelne13sa24 || paralelne14sa23)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        public static bool DaLiJeSumnjivTrapez(int x1, int x2, int x3, int x4, int y1, int y2, int y3, int y4)
        {
            if (!DaLiJeTrapez(x1, x2, x3, x4, y1, y2, y3, y4))
            {
                // ako nije trapez, onda sigurno nije ni "sumnjiv" trapez
                return false;
            }

            bool paralelne12sa34 = DaLiSuDuziParalelne(x1, x2, x3, x4, y1, y2, y3, y4);
            bool paralelne13sa24 = DaLiSuDuziParalelne(x1, x3, x2, x4, y1, y3, y2, y4);
            bool paralelne14sa23 = DaLiSuDuziParalelne(x1, x4, x2, x3, y1, y4, y2, y3);

            if ((paralelne12sa34 && DaLiJeJednaDuzDuploVeca(x1, x2, x3, x4, y1, y2, y3, y4)) ||
                (paralelne13sa24 && DaLiJeJednaDuzDuploVeca(x1, x3, x2, x4, y1, y3, y2, y4)) ||
                (paralelne14sa23 && DaLiJeJednaDuzDuploVeca(x1, x4, x2, x3, y1, y4, y2, y3)))
            {
                return true;
            }
            return false;
        }
        public static bool DaLiJeJednaDuzDuploVeca(int x1, int x2, int x3, int x4, int y1, int y2, int y3, int y4)
        {
            // poredimo duzi (x1,y1),(x2,y2) i (x3,y3),(x4,y4)
            double duzina12 = DuzinaDuzi(x1, x2, y1, y2);
            double duzina34 = DuzinaDuzi(x3, x4, y3, y4);
            if (PribliznoJednako(duzina12 / duzina34, 2) ||
                PribliznoJednako(duzina34 / duzina12, 2))
            {
                return true;
            }
            return false;
        }

        public static bool DaLiSuDuziParalelne(int x1, int x2, int x3, int x4, int y1, int y2, int y3, int y4)
        {
            bool paralelne = (x1 == x2 && x3 == x4) ||
               ((x1 != x2 && x3 != x4) &&
                   (Math.Abs(y2 - y1) / Math.Abs(x2 - x1) == Math.Abs(y4 - y3) / Math.Abs(x4 - x3)));
            return paralelne;
        }

        public static bool PribliznoJednako(double a, double b)
        {
            return Math.Abs(a - b) < 0.001;
        }

        public static double DuzinaDuzi(int x1, int x2, int y1, int y2)
        {
            double xKomponenta = (x2 - x1) * (x2 - x1);
            double yKomponenta = (y2 - y1) * (y2 - y1);
            return Math.Sqrt(xKomponenta + yKomponenta);
        }
    }
}