#include <algorithm>
#include <iostream>
#include <iomanip>
#include <vector>
#include <chrono>
#include <string>
using namespace std;
typedef long long ll;

int solve(string& s, const string& word)
{
	vector<vector<int>> dp(word.size(), vector<int>(s.size()));
	vector<vector<pair<int, int>>> prev(word.size(), vector<pair<int, int>>(s.size(), { -1,-1 }));

	dp[0][0] = (s[0] == word[0]);
	prev[0][0] = { -1,-1 };
	for (int i = 1; i < s.size(); i++)
	{
		dp[0][i] = dp[0][i - 1] + (s[i] == word[0]);
		prev[0][i] = { 0,i - 1 };
	}
	
	for (int row = 1; row < word.size(); row++)
	{
		for (int col = row; col < s.size(); col++)
		{
			if (s[col] == word[row])
			{
				int delete_letter = dp[row][col - 1] + 1;
				int keep_letter = dp[row - 1][col - 1];
				if (delete_letter < keep_letter)
				{
					dp[row][col] = delete_letter;
					prev[row][col] = { row,col - 1 };
				}
				else
				{
					dp[row][col] = keep_letter;
					prev[row][col] = { row - 1,col - 1 };
				}
				
			}
			else
			{
				dp[row][col] = dp[row][col - 1];
				prev[row][col] = { row,col - 1 };
			}
		}
	}

	int current_row = word.size()-1, current_col = s.size()-1;
	while (true)
	{
		int prev_row = prev[current_row][current_col].first;
		int prev_col = prev[current_row][current_col].second;
		if (prev_row == -1)
		{
			if (current_row == 0 && current_col == 0 && dp[0][0] == 1)
			{
				s[0] = '*';
			}
			break;
		}

		int prev_value = dp[prev_row][prev_col];
		if (prev_row == current_row && prev_value < dp[current_row][current_col])
		{
			s[current_col] = '*';
		}
		current_row = prev_row;
		current_col = prev_col;
	}


	return dp.back().back();
}

int main()
{
	ios::sync_with_stdio(false);
	cin.tie(0);

	string s, word;
	cin >> s >> word;
	cout << solve(s, word) << "\n";
	cout << s << "\n";

	return 0;
}