#include <algorithm>
#include <iostream>
#include <iomanip>
#include <vector>
#include <string>
#include <chrono>
#include <map>
#include <set>
using namespace std;
typedef long long ll;
struct point
{
	ll x, y;
};


ll gcd(ll a, ll b)
{
	if (b == 0)
		return a;
	return gcd(b, a % b);
}

ll solve(const vector<point>& points)
{
	int n = points.size();
	map<tuple<ll, ll, ll>, ll> lines_cnt; // Tuple dy, dx, length^2
	for (int i = 0; i < n; i++)
	{
		for (int j = i + 1; j < n; j++)
		{
			ll dy = points[i].y - points[j].y;
			ll dx = points[i].x - points[j].x;

			ll len = dy * dy + dx * dx;

			if (dy == 0)
			{
				dy = -1;
				dx = -2;
			}
			else if (dx == 0)
			{
				dx = -1;
				dy = -2;
			}
			else
			{
				ll g = gcd(dy, dx);
				dy /= g;
				dx /= g;
			}
			lines_cnt[tuple<ll, ll, ll>(dy, dx, len)]++;
		}
	}

	ll solution = 0;
	for (int i = 0; i < n; i++)
	{
		for (int j = i+1; j < n; j++)
		{
			ll dy = points[i].y - points[j].y;
			ll dx = points[i].x - points[j].x;

			ll len = dy * dy + dx * dx;

			if (dy == 0)
			{
				dy = -1;
				dx = -2;
			}
			else if (dx == 0)
			{
				dx = -1;
				dy = -2;
			}
			else
			{
				ll g = gcd(dy, dx);
				dy /= g;
				dx /= g;
			}
			ll longer_len = 4 * len;
			ll longer_cnt = lines_cnt[tuple<ll, ll, ll>(dy, dx, longer_len)];
			solution += longer_cnt;
		}
	}

	return solution;
}

int main()
{
	ios::sync_with_stdio(false);
	cin.tie(0);

	int n; cin >> n;
	vector<point> points(n);
	for (int i = 0; i < n; i++)
		cin >> points[i].x >> points[i].y;
	cout << solve(points);

	return 0;
}