using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak3
{
    class Program
    {
        struct Tacka
        {
            public int x, y;
        }
        struct Prava
        {
            public Tacka T1, T2;
        }
        struct Trapez
        {
            public double Osnovica1, Osnovica2;
        }
        static bool ProveriSumnjive(Tacka[] tacke)
        {
            if (!ProveriKolinearnost(tacke))
            {
                var prave = KreirajPrave(tacke);
                if (prave.Length > 0)
                {
                    var osnovice = ProveriTrapez(prave);
                    if (osnovice.Length > 0)
                    {
                        foreach (var o in osnovice)
                        {
                            if (Math.Abs(Math.Abs(o.Osnovica1 - o.Osnovica2) - Math.Min(o.Osnovica1, o.Osnovica2)) < 0.01)
                            {
                                return true;
                            }
                        }
                    }
                }
            }

            return false;
        }
        static double RastojenjeTacaka(Tacka t1, Tacka t2)
        {
            return Math.Sqrt((t2.x - t1.x) * (t2.x - t1.x) + (t2.y - t1.y) * (t2.y - t1.y));
        }
        static bool DuziImajuZajednickuTacku(Prava d1, Prava d2)
        {
            if (d1.T1.x == d2.T1.x && d1.T1.y == d2.T1.y) return true;
            if (d1.T1.x == d2.T2.x && d1.T1.y == d2.T2.y) return true;
            if (d1.T2.x == d2.T2.x && d1.T2.y == d2.T2.y) return true;
            if (d1.T2.x == d2.T1.x && d1.T2.y == d2.T1.y) return true;
            return false;
        }
        static bool ProveriKolinearnost(Tacka[] tacke)
        {
            var brojTacaka = tacke.Length;
            if (tacke.Length <= 2) return false;
            for (var i = 0; i < brojTacaka - 1; i++)
            {
                for (var j = i + 1; j <= brojTacaka - 1; j++)
                {
                    for (var k = j + 1; k < brojTacaka; k++)
                    {
                        if ((tacke[j].x - tacke[i].x) * (tacke[k].y - tacke[i].y) - (tacke[k].x - tacke[i].x) * (tacke[j].y - tacke[i].y) == 0)
                        {
                            return true;
                        }
                    }
                }
            }

            return false;
        }

        static Prava[] KreirajPrave(Tacka[] tacke)
        {
            var result = new Prava[] { };
            var brojTacaka = tacke.Length;
            if (brojTacaka < 2) return result;
            int brojPravih = 0;
            for (var i = 0; i < brojTacaka - 1; i++)
            {
                for (var j = i + 1; j <= brojTacaka - 1; j++)
                {
                    brojPravih++;
                    Array.Resize(ref result, brojPravih);
                    Prava p;
                    result[brojPravih - 1].T1.x = tacke[i].x;
                    result[brojPravih - 1].T1.y = tacke[i].y;
                    result[brojPravih - 1].T2.x = tacke[j].x;
                    result[brojPravih - 1].T2.y = tacke[j].y;
                }
            }
            return result;
        }

        static Trapez[] ProveriTrapez(Prava[] prave)
        {
            var result = new Trapez[] { };
            var brojPravih = prave.Length;

            int brojOsnovica = 0;
            for (var i = 0; i < brojPravih - 1; i++)
            {
                for (var j = i + 1; j < brojPravih; j++)
                {

                    if (DuziImajuZajednickuTacku(prave[i], prave[j])) continue;
                    decimal k1 = 1M;
                    decimal k2 = 1M;
                    if (Math.Abs(prave[j].T2.x - prave[j].T1.x) > 0)
                    {
                        k1 = Math.Abs(Math.Abs(prave[j].T2.y - prave[j].T1.y) / Math.Abs(prave[j].T2.x - prave[j].T1.x));

                    }
                    if (Math.Abs(prave[i].T2.x - prave[i].T1.x) > 0)
                    {
                        k2 = Math.Abs((prave[i].T2.y - prave[i].T1.y) / Math.Abs(prave[i].T2.x - prave[i].T1.x));
                    }
                    if (Math.Abs(k1 - k2) < 0.0001M)
                    {
                        brojOsnovica++;
                        Array.Resize(ref result, brojOsnovica);
                        result[brojOsnovica - 1].Osnovica1 = RastojenjeTacaka(prave[i].T1, prave[i].T2);
                        result[brojOsnovica - 1].Osnovica2 = RastojenjeTacaka(prave[j].T1, prave[j].T2);
                    }
                }
            }

            return result;
        }
        static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            Tacka[] rasporedTakmicara = new Tacka[n];
            for (int i = 0; i < n; i++)
            {
                string[] s = Console.ReadLine().Split();
                rasporedTakmicara[i].x = int.Parse(s[0]);
                rasporedTakmicara[i].y = int.Parse(s[1]);
            }
            int brojSumnjivih = 0;
            int brojGrupa = 0;

            for (var i = 0; i < n - 2; i++)
            {
                for (var j = i + 1; j < n - 1; j++)
                {
                    for (var k = j + 1; k < n - 1; k++)
                    {
                        for (var l = k + 1; l < n; l++)
                        {
                            var grupaTakmicara = new Tacka[4];
                            grupaTakmicara[0] = rasporedTakmicara[i];
                            grupaTakmicara[1] = rasporedTakmicara[j];
                            grupaTakmicara[2] = rasporedTakmicara[k];
                            grupaTakmicara[3] = rasporedTakmicara[l];
                            brojGrupa++;
                            if (ProveriSumnjive(grupaTakmicara))
                            {
                                brojSumnjivih++;
                            }
                        }
                    }
                }
            }
            Console.WriteLine(brojSumnjivih);
        }
    }
}