#include <bits/stdc++.h>
using namespace std;

using ll = long long;
using ld = long double;

const int MAX = 200005;
const int T = 100001;
const int N = 200000;

ll res;

ll a[N+5];

struct Segment{
    ll sum, cnt;
} seg[MAX*4+5];

void init(int node, int l, int r){
    seg[node].sum = seg[node].cnt = 0;
    if(l == r) return;
    int mid = (l+r)/2;
    init(node*2, l, mid);
    init(node*2+1, mid+1, r);
}

void upd(int node, int l, int r, int x, int v){
    if(l == r){
        seg[node].sum += v*l;
        seg[node].cnt += v;
        return;
    }
    int mid = (l+r)/2;
    if(x <= mid) upd(node*2, l, mid, x, v);
    else upd(node*2+1, mid+1, r, x, v);
    seg[node].sum = seg[node*2].sum + seg[node*2+1].sum;
    seg[node].cnt = seg[node*2].cnt + seg[node*2+1].cnt;
}

ll query(int node, int l, int r, int k){
    if(l == r) return 1LL*l*k;
    int mid = (l+r)/2;
    if(seg[node*2+1].cnt >= k) return query(node*2+1, mid+1, r, k);
    return seg[node*2+1].sum + query(node*2, l, mid, k - seg[node*2+1].cnt);
}

void solve(int n, int k){
    init(1, 1, MAX);
    for(int i=2; i<=n; i++) upd(1, 1, MAX, a[i] + T, 1);
    ll mx = -a[1];
    upd(1, 1, MAX, -a[1] + T, 1);
    for(int i=2; i<=n; i++){
        upd(1, 1, MAX, a[i] + T, -1);
        upd(1, 1, MAX, mx + T, -1);
        res = max(res, a[i] + mx + query(1, 1, MAX, k - 2) - 1LL*(k-2)*T);
        upd(1, 1, MAX, mx + T, 1);
        upd(1, 1, MAX, -a[i] + T, 1);
        mx = max(mx, -a[i]);
    }
}

int main(){
    ios_base::sync_with_stdio(false), cin.tie(0);
    cout.precision(10);
    cout << fixed;

    int n, k;
    cin >> n >> k;
    for(int i=1; i<=n; i++) cin >> a[i];
    solve(n, k);
    reverse(a+1, a+1+n);
    solve(n, k);
    cout << res << "\n";
    return 0;
}