#include <iostream>
#include <string>
#include <map>
#include <vector>
#include <algorithm>

struct CuttofPoint
{	
	int skip;
	int keep;	
	int value;
};

struct Cuttof
{
	int skip;	
	CuttofPoint* begin;
	CuttofPoint* end;	
};

CuttofPoint cuttofPoints[3000];
int numCuttofPoints = 0;
Cuttof cuttofs[3000];
int numCuttofs = 0;

struct Node
{
	CuttofPoint* cuttofPoint;
	int value;	
};
Node nodes[3000];
int numNodes;

Cuttof GetCuttof(const char* str, int n, int skip)
{
	int size = std::min(n - skip, skip);	

	Cuttof cuttof;
	cuttof.skip = skip;
	cuttof.begin = cuttofPoints + numCuttofPoints;
		
	for (int i = size - 1; i >= 0; --i)
		if (str[skip - i - 1] == str[skip + i])
		{
			CuttofPoint point;		
			point.keep = i + 1;									
			point.skip = skip;			
			cuttofPoints[numCuttofPoints++] = point;			
		}	

	cuttof.end = cuttofPoints + numCuttofPoints;	

	for (CuttofPoint* it = cuttof.begin; it != cuttof.end; ++it)
		it->value = cuttof.end - it;
	
	return cuttof;
}

void GenerateCuttofs(const char* str, int n)
{
	for (int i = n - 2; i >= 2; --i)
	{		
		Cuttof cuttof = GetCuttof(str, n, i);

		if (cuttof.end - cuttof.begin > 0)		
			cuttofs[numCuttofs++] = cuttof;		
	}
}

void Insert(Node node)
{
	if (numNodes == 0)
	{
		nodes[0] = node;
		numNodes = 1;
		return;
	}	
	
	int i = std::lower_bound(nodes, nodes + numNodes, node, 
		[](const Node& a, const Node& b) {
			return a.value > b.value;
		}) - nodes;

	memmove(nodes + i + 1, nodes + i, (numNodes - i) * sizeof(Node));

	nodes[i] = node;

	++numNodes;	
}

void ConnectNodes()
{
	for (int i = 0; i < numCuttofPoints; ++i)
	{
		int j = 0;		
		while (j < numNodes && cuttofPoints[i].skip + cuttofPoints[i].keep > nodes[j].cuttofPoint->skip) 
			++j;

		int value = cuttofPoints[i].value;
		if (j != numNodes)		
			value += nodes[j].value;

		if (value > nodes[j].value)
		{
			Node node;
			node.cuttofPoint = cuttofPoints + i;
			node.value = value;
			Insert(node);
		}
	}
}

int main()
{
	std::string str;
	std::getline(std::cin, str);	

	GenerateCuttofs(str.c_str(), str.size());		

	ConnectNodes();

	if (numNodes > 0)
	{
		printf("%d", nodes[0].value);
	}
	else
		printf("0");
}