#include <iostream>
using namespace std;
typedef unsigned int uint;

void inicijalnoStanjeKoriscenih(uint* kor, uint izabranih){
    for(uint i = 0; i < izabranih; i++){
        kor[i] = i;
    }
}

void inicijalnoStanjePuta(bool* kor, uint izabranih){
    for(uint i = 0; i < izabranih; i++){
        kor[i] = false;
    }
}

bool KrajKoriscenih(uint* kor, uint& brojNapitaka, uint izabranih){
    uint temp = 0;
    if(kor[0] == brojNapitaka - izabranih){
        temp++;
        for(uint i = 1; i < izabranih; i++){
            if(kor[i] == brojNapitaka - izabranih + i){
                temp++;
            }
        }
    }

    if(temp == izabranih){
        return true;
    }else{
        return false;
    }
}

bool KrajPuta(bool* kor, uint izabranih){
    uint temp = 0;
    if(kor[0] == true){
        temp++;
        for(uint i = 1; i < izabranih; i++){
            if(kor[i] == true){
                temp++;
            }
        }
    }

    if(temp == izabranih){
        return true;
    }else{
        return false;
    }
}

void uvecajPoslednjiKorisceni(uint* kor, uint brojNapitaka, uint depth){
    kor[depth]++;
    if(kor[depth] == brojNapitaka){
        uvecajPoslednjiKorisceni(kor, brojNapitaka - 1, depth - 1);
        kor[depth] = kor[depth - 1] + 1;
    }
}

void uvecajPoslednjiPut(bool* kor, uint depth){

    if(kor[depth] == true){
        kor[depth] = false;
        uvecajPoslednjiPut(kor, depth - 1);
    }else{
        kor[depth] = true;
    }
}

int racunajMocPuta(bool* put, uint* mocNapitaka, uint* korisceni, uint izabranih){ /// 2
    int kopija[izabranih];
    for(int i = 0; i < izabranih; i++){
        kopija[i] = mocNapitaka[korisceni[i]];
    }

    uint prvi = 0;
    uint poslednji = izabranih - 1;
    uint vrati;
    for(uint i = 0; i < izabranih - 1; i++){
        switch(put[i]){
        case true:
            kopija[poslednji] -= kopija[prvi];
            vrati = poslednji;
            prvi++;
            break;
        case false:
            kopija[prvi] -= kopija[poslednji];
            vrati = prvi;
            poslednji--;
            break;
        }
    }
    return kopija[vrati];
}

int racunajMocKoriscenih(uint* mocNapitaka, uint* korisceni, uint izabranih){ /// 2
    bool put[izabranih - 1];
    inicijalnoStanjePuta(put, izabranih - 1);
    int moc = 0;
    int temp;
    bool smt = true;

    while(!KrajPuta(put, izabranih - 1)){
        temp = racunajMocPuta(put, mocNapitaka, korisceni, izabranih);
        if(!smt){
            if(moc < temp){
                moc = temp;
            }
        }else{
            smt = false;
            moc = temp;
        }

        uvecajPoslednjiPut(put, izabranih - 2);
    }
    temp = racunajMocPuta(put, mocNapitaka, korisceni, izabranih);
    if(moc < temp){
        moc = temp;
    }

    return moc;
}

int main()
{
    uint brojNapitaka, izabranihNapitaka;
    cin >> brojNapitaka >> izabranihNapitaka;

    uint mocNapitaka[brojNapitaka];
    uint korisceni[izabranihNapitaka];

    for(uint i = 0; i < brojNapitaka; i++){
        cin >> mocNapitaka[i];
    }

    int moc;
    int temp;
    bool smt = true;
    inicijalnoStanjeKoriscenih(korisceni, izabranihNapitaka);

    while(!KrajKoriscenih(korisceni, brojNapitaka, izabranihNapitaka)){
        temp = racunajMocKoriscenih(mocNapitaka, korisceni, izabranihNapitaka);
        if(!smt){
            if(moc < temp){
                moc = temp;
            }
        }else{
                smt = false;
                moc = temp;
            }
        uvecajPoslednjiKorisceni(korisceni, brojNapitaka, izabranihNapitaka - 1);
    }
    temp = racunajMocKoriscenih(mocNapitaka, korisceni, izabranihNapitaka);
    if(moc < temp){
        moc = temp;
    }

    cout << endl << moc << endl;
    return 0;
}