#include <iostream>
#include <vector>
#include <limits>

struct potion
{
	int power;
	int original_index;

	potion(int pwr, int idx) : power {pwr}, original_index{idx} {}
};

int main()
{
	int num_potions, num_allowed;
	int max_power = std::numeric_limits<int>::min();

	std::cin >> num_potions >> num_allowed;

	std::vector<potion> potions;

	for(int i = 0; i < num_potions; i++)
	{
		int input;
		std::cin >> input;
		potions.emplace_back(input, i);
	}

	for(int i = 1; i < num_allowed; i++)
	{
		auto idxF = potions.front();
		auto idxE = potions.back();

		int try1 = idxF.power - idxE.power;
		int try2 = idxE.power - idxF.power;

		if(try1 > try2)
		{
			idxF.power = try1;
			if(try1 > max_power)
				max_power = try1;
			potions.pop_back();
		}
		else
		{
			idxE.power = try2;
			if(try2 > max_power)
				max_power = try2;
			potions.erase(potions.end());
		}
	}

	std::cout << max_power;

	return 0;
}