#include <vector>
#include <iostream>

class FieldTrip {
public:   // Fields
    constexpr static const char* good = "Tak";
    constexpr static const char* bad = "Nie";
private:  // Fields
    uint64_t bananas;
    uint64_t students;
    uint64_t groups;
public:   // Ctors
    FieldTrip() = default;
    FieldTrip(const uint64_t&, const uint64_t&, const uint64_t&);
public:   // Methods
    bool Outcome() const;
public:   // Friends
    friend std::istream& operator >>(std::istream&, FieldTrip&);
};

int main() {
    int t;
    std::cin >> t;
    std::vector<FieldTrip> trips(t);
    for (auto& trip : trips) {
        std::cin >> trip;
    }
    for (const auto& trip : trips) {
        std::cout << (trip.Outcome() ? FieldTrip::good : FieldTrip::bad) << std::endl;
    }
    return 0;
}


// Constructors
FieldTrip::FieldTrip(const uint64_t& bananas, const uint64_t& students, const uint64_t& groups)
: bananas(bananas), students(students), groups(groups) {
}

// Methods
bool FieldTrip::Outcome() const {
    uint64_t min = students / groups;
    uint64_t inflation = students % groups;
    uint64_t required = (students + 2 * min * inflation + inflation * inflation + groups * min * min) / 2;
    return bananas >= required;
}

// Friends
std::istream& operator >>(std::istream& in, FieldTrip& trip) {
    in >> trip.students >> trip.bananas >> trip.groups;
    return in;
}