#include <iostream>
#include <vector>
#include <algorithm>
#include <string>
#include <limits.h>
using namespace std;

vector<vector<int>> memo;

int same_cnt(const string& a, const string& b)
{
	int cnt = 0;
	string a_temp = a;
	reverse(a_temp.begin(), a_temp.end());
	for (int i = 0; i < min(a_temp.length(), b.length()); i++)
		cnt += (a_temp[i] == b[i]);

	return cnt;
}

int resi(const string& s, int pos, int length)
{
	int n = s.length();
	if (memo[pos][length] != -1)
		return memo[pos][length];

	if (pos + length == s.length())
	{
		memo[pos][length] = 0;
		return 0;
	}

	int max_score = INT_MIN;
	string a = s.substr(pos, length);
	reverse(a.begin(), a.end());
	int same = (a[0] == s[pos + length]);
	for (int j = 2; j <= n - pos - length; j++)
	{
		same += (j - 1 < length && a[j - 1] == s[pos + length + j - 1]);
		string b = s.substr(pos + length, j);
		//int same = same_cnt(a, b);
		int curr_score = resi(s, pos + length, j) + same;
		max_score = max(max_score, curr_score);
	}

	memo[pos][length] = max_score;
	return max_score;
}

int main()
{
	string s; cin >> s;
	memo = vector<vector<int>>(s.length(), vector<int>(s.length() + 1, -1));
	int max_score = INT_MIN;
	for (int lengths = 2; lengths <= s.length(); lengths++)
		max_score = max(resi(s, 0, lengths), max_score);
	cout << max_score << endl;
	return 0;
}