#include <stdio.h>
#include <stdbool.h>

#define MAX_U 10
#define MAX_B 10
#define MAX_G 10

const char *da = "Tak";
const char *ne = "Nie";

bool proveri(int br_ucenika, long long br_bananica, int br_grupa) {
    if (br_grupa > br_ucenika) {
        return false; //nemoguce, jer ce biti praznih grupa
    }
    if (br_ucenika > br_bananica) {
        return false; //nemoguce, jer ce biti ucenika bez bananica
    }
    if (br_bananica/br_ucenika * br_grupa == 1) {
        return false; //nemoguce, jer ce svaki ucenik dobiti isti broj a svi ce se nalaziti u istoj grupi
    }
    if ((float)br_bananica/br_ucenika < (float)br_bananica/br_grupa) {
        return false; //nemoguce, jer ce svaki ucenik trebati da dobije vise nego u njegovoj grupi
    }

    return true;
}

int main() {
    int T;

    int br_ucenika[MAX_U]; // N
    long long br_bananica[MAX_B]; // M
    int br_grupa[MAX_G]; // K

    scanf("%d", &T);

    for (int i = 0; i<T; i++) {
        scanf("%d%lld%d", &br_ucenika[i], &br_bananica[i], &br_grupa[i]);
    }

    for (int i = 0; i<T; i++) {
        if (proveri(br_ucenika[i], br_bananica[i], br_grupa[i])) {
            printf("%s\n", da);
        } else {
            printf("%s\n", ne);
        }
    }
    return 0;
}