/*using System;
using Segment = System.Tuple<double, long, long>;
using System.Linq;


namespace kvalifikacije_3
{
    class Konjugacija
    {
        static bool konjugovani(Segment a, Segment b)
        {
            return ((b.Item2 <= a.Item1) && (a.Item1 <= b.Item3)) && (a.Item2 <= b.Item1);
        }

        static void Main()
        {
            //Korak 1 - Ucitavamo unesene podatke

            long n = long.Parse(Console.ReadLine());
            Segment[] segmenti = new Segment[n];
            for(long i = 0; i < n; i++) {
                string[] unos = Console.ReadLine().Split();
                long a = long.Parse(unos[0]);
                long b = long.Parse(unos[1]);
                double centar = (double)(a + b) / 2;
                segmenti[i] = new Segment(centar, a, b);
            }

            //Korak 2 -  sortiramo tupple

            Array.Sort(segmenti);

            //Korak 3 - 

            long br = 0;
            for(long i = 0; i < n - 1; i++) {
                for(long j = i + 1; j < n; j++) {
                    if (segmenti[j].Item1 > segmenti[i].Item3) {
                        break;
                    }

                    if (konjugovani(segmenti[i], segmenti[j])) br++;
                }
            }

            //Korak 4 -

            Console.WriteLine(br);
        }
    }
}*/

using System;
using Segment = System.Tuple<int, int, double>;

namespace kvalifikacije_3
{
    class Konjugacija
    {
        static void Main()
        {
            //Korak 1 - ucitavamo ulazne podatke i odredjujemo centar segmenata

            int n = int.Parse(Console.ReadLine());

            Segment[] segmenti = new Segment[n];
            for (int i = 0; i < n; i++) {
                string[] unos = Console.ReadLine().Split();
                int pocetak = int.Parse(unos[0]);
                int kraj = int.Parse(unos[1]);
                double centar = (double)(kraj + pocetak) / 2;
                segmenti[i] = new Segment(pocetak, kraj, centar);
            }

            //Korak 2 - sortiramo segmente

            Array.Sort(segmenti);

            //Korak 3 - 

            int br = 0;
            int j = -1;
            for(int i = 0; i < n - 1; i++) {
                j = Array.FindIndex(segmenti, i + 1, segment => segment.Item2 >= segmenti[i].Item3);
                while (true) {
                    if (j == -1) break;

                    if (segmenti[j].Item1 > segmenti[i].Item3) break;

                    if ((segmenti[i].Item1 <= segmenti[j].Item3) && (segmenti[j].Item3 <= segmenti[i].Item2)) {
                        br++;
                    }

                    j = Array.FindIndex(segmenti, j + 1, segment => segment.Item2 >= segmenti[i].Item3);
                }
            }

            //Korak 4 - ispisujemo broj

            Console.WriteLine(br);
        }

    }
}