#include<bits/stdc++.h>
using namespace std;

using ll = long long;

const int mxN = 1e5 + 1;
vector<int> adj[mxN];
vector<int> dub(mxN, -1);

void dfs(int node, int depth = 0)
{
	dub[node] = depth;
	for (int child : adj[node]) {
		if (dub[child] == -1) {
			dfs(child, depth + 1);
		}
	}
}

int main()
{
	ios::sync_with_stdio(0);
	cin.tie(0);
	cout.tie(0);

	int n, m;
	cin >> n >> m;

	for (int i = 2; i <= n; i++) {
		int sef;
		cin >> sef;

		adj[sef].push_back(i);
		adj[i].push_back(sef);
	}

	dfs(1);

	map<ll, int> arrived;
	for (int i = 0; i < m; i++) {
		ll t; int v;
		cin >> t >> v;

		arrived[t + dub[v]]++;
	}
	
	int ans = 0;
	for (auto it : arrived) {
		ans += it.second - (it.second % 2);
	}
	cout << ans << "\n";
	return 0;
}