#include <iostream>
#include <unordered_set>

class Ecosystem {
private:  // Fields
    int ancestorFactor;
    std::unordered_set<int> species;
public:   // Constructors
    Ecosystem(std::istream&);
public:   // Methods
    int CountOfAncestors() const;
};

int main() {
    Ecosystem ecosystem(std::cin);
    std::cout << ecosystem.CountOfAncestors() << std::endl;
    return 0;
}


// Ecosystem
Ecosystem::Ecosystem(std::istream& in) {
    int n;
    in >> n >> ancestorFactor;
    while (n--) {
        int id;
        in >> id;
        species.insert(id);
    }
}

// Methods
int Ecosystem::CountOfAncestors() const {
    std::unordered_set<int> ancestors;
    for (auto& organism : species) {
        ancestors.insert(organism / ancestorFactor);
    }
    return ancestors.size();
}