#include <unordered_set>
#include <algorithm>
#include <iostream>
#include <float.h>
#include <vector>
#include <stack>

enum Location {
    Left = 0,
    Center,
    Right
};

struct Point {
    int segmentId;
    double position;
    Location location;
};

int Conjugates(std::vector<Point>&);
void Untie();

int main() {
    Untie();
    int n;
    std::cin >> n;
    std::vector<Point> points(3 * n);
    for (int i = 0; i < n; i++) {
        int ix = 3 * i;
        std::cin >> points[ix].position >> points[ix + 2].position;
        points[ix + 1].position = 0.5 * (points[ix].position + points[ix + 2].position);
        for (int j = 0; j < 3; j++) {
            points[ix + j].location = (Location) j;
            points[ix + j].segmentId = i;
        }
    }
    std::cout << Conjugates(points) << std::endl;
    return 0;
}


void Untie() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(nullptr);
    std::cout.tie(nullptr);
    std::cerr.tie(nullptr);
}
int Conjugates(std::vector<Point>& points) {
    std::sort(points.begin(), points.end(), [](const Point& p, const Point& q) {
        if (std::abs(p.position - q.position) >= DBL_EPSILON) {
            return p.position < q.position;
        }
        return p.location < q.location;
    });
    int total = 0;
    int penalty = 0;
    std::unordered_set<int> availibleSegmentCenters;
    std::stack<int> penalties;
    for (const auto& point : points) {
        switch (point.location) {
        case Left:
            penalties.push(penalty);
            penalty = availibleSegmentCenters.size();
            continue;
        case Center:
            total += availibleSegmentCenters.size() - penalty;
            availibleSegmentCenters.insert(point.segmentId);
            if (penalties.size()) {
                penalty = penalties.top();
                penalties.pop();
                continue;
            }
            penalty = 0;
            continue;
        case Right:
            availibleSegmentCenters.erase(point.segmentId);
            if (penalties.size()) {
                penalty = penalties.top();
                penalties.pop();
                continue;
            }
            penalty = 0;
            continue;
        }
    }
    return total;
}