#include <iostream>
#include <vector>
#include <algorithm>
#include <set>
using namespace std;

struct segment
{
	int center;
	int half_length;
	int index;
};

class segment_tree
{
public:
	int n;
	vector<int> t;
	segment_tree(int n, const vector<int>& a) {
		this->n = n;
		t = vector<int>(2 * n);
		for (int i = n; i < 2 * n; i++) t[i] = a[i - n];
		for (int i = n - 1; i > 0; --i) t[i] = t[i << 1] + t[i << 1 | 1];
	}

	void modify(int p, int value) {
		for (t[p += n] = value; p > 1; p >>= 1) t[p >> 1] = t[p] + t[p ^ 1];
	}

	int query(int l, int r) {
		int res = 0;
		for (l += n, r += n; l < r; l >>= 1, r >>= 1) {
			if (l & 1) res += t[l++];
			if (r & 1) res += t[--r];
		}
		return res;
	}
};

int main()
{
	int n; cin >> n;
	vector<segment> segments(n);
	vector<int> centers(n);
	for (int i = 0; i < n; i++)
	{
		int a, b; cin >> a >> b;
		segments[i].center = a + b;
		centers[i] = a + b;
		segments[i].half_length = b - a;
	}
	sort(segments.begin(), segments.end(), [](segment a, segment b) { return a.center < b.center; });
	for (int i = 0; i < n; i++) segments[i].index = i;
	sort(segments.begin(), segments.end(), [](segment a, segment b) { return a.half_length < b.half_length; });
	sort(centers.begin(), centers.end());
	segment_tree seg_tree = segment_tree(n, vector<int>(n, 1));
	long long conjugate_cnt = 0;
	for (int i = 0; i < n; i++)
	{
		segment curr_segment = segments[i];
		seg_tree.modify(curr_segment.index, 0);
		int l = lower_bound(centers.begin(), centers.end(), curr_segment.center - curr_segment.half_length) - centers.begin();
		int r = upper_bound(centers.begin(), centers.end(), curr_segment.center + curr_segment.half_length) - centers.begin();
		conjugate_cnt += (long long)seg_tree.query(l, r);
	}

	cout << conjugate_cnt << endl;
}