#include <bits/stdc++.h>

#define MAXN 150005
#define pii pair<int,int>
#define fi first
#define se second

using namespace std;

bool cmp(pii a, pii b){
    return a>b;
}

int tree[3*MAXN]={0};

void update(int v, int l,int r,int& x,const int& value){
    if(r<=l){
        tree[v]+=value;
    }
    else{
        int mid = (l+r)/2;
        if(mid<x){
            update(v*2+2,mid+1,r,x,value);
        }
        else{
            update(v*2+1,l,mid,x,value);
        }
        tree[v]=tree[v*2+1]+tree[v*2+2];
    }
}

int query(int v, int l,int r,int& li,int& ri){
    if(li<=l&&ri<=r){
        return tree[v];
    }
    int mid = (l+r)/2;
    int s=0;
    if(mid<ri){
        s+=query(v*2+2,mid+1,r, li, ri);
    }
    if(li<=mid){
        s+=query(v*2+1,l,mid,li,ri);
    }
    return s;
}

int bsup(int x,vector<int>& center,int n){
    int l=0;
    int r=n-1;
    while(l<r){
        int mid=((l+r)/2);
        if(center[mid]<x){
            l=mid+1;
        }

        else{
            r=mid;
        }
    }
    return l;
}

int bsdown(int x,vector<int>& center,int n){
    int l=0;
    int r=n-1;
    while(l<r){
        int mid=((l+r+1)/2);
        if(center[mid]>x){
            r=mid-1;
        }

        else{
            l=mid;
        }
    }
    return l;
}


int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n,m=0;
    cin>>n;
    vector<pii > segm(n);
    set<int> exist;
    vector<int> center(n);

    for(int i=0;i<n;i++){
        int a, b;
        cin >> a >> b;
        segm[i]={b-a,b+a}; 
        exist.insert(a+b);
        if(exist.size()>m){
            center[m]={a+b};
            m++;
        }
    }
    center.resize(m);


    sort(segm.begin(),segm.end(),cmp);
    sort(center.begin(),center.end());
    long long res=0;
    for(int i=0;i<n;i++){
        int a=bsup(segm[i].se-segm[i].fi,center,m);

        int b=bsdown(segm[i].se+segm[i].fi,center,m);

        int c=bsdown(segm[i].fi,center,m);
        res+=query(0,0,m-1,a,b);
        update(0,0,m-1,c,1);
    }

    cout << res << endl;
    return 0;
}