#include <algorithm>
#include <iostream>
#include <vector>
#include <set>
using namespace std;
typedef long long ll;

class SegmentTree
{
public:
	SegmentTree(const vector<ll>& v);
	ll sum_query(int l, int r);
	void update(int pos, ll new_value);
private:
	vector<ll> tree;
	int element_cnt;
};

int main()
{
	ios::sync_with_stdio(false);
	cin.tie(0);

	int n; cin >> n;
	vector<ll> segment_lengths(n);
	vector<ll> centers(n);
	for (int i = 0; i < n; i++)
	{
		ll left, right;
		cin >> left >> right;
		segment_lengths[i] = right - left;
		centers[i] = left + right; // not a bug
	}

	vector<ll> sorted_centers = centers;
	sort(sorted_centers.begin(), sorted_centers.end());
	auto sorted_centers_tree = SegmentTree(vector<ll>(n));

	vector<pair<ll, int>> jaje(n);
	for (int i = 0; i < n; i++)
		jaje[i] = { segment_lengths[i], i};
	
	sort(jaje.begin(), jaje.end(), greater<pair<ll,int>>());

	ll solution = 0;
	for (int i = 0; i < n; i++)
	{
		ll center = centers[jaje[i].second];
		ll len = jaje[i].first;
		int left_boundary = lower_bound(sorted_centers.begin(),sorted_centers.end(), center - len) - sorted_centers.begin();
		int right_boundary = upper_bound(sorted_centers.begin(), sorted_centers.end(), center + len) - sorted_centers.begin();
		
		ll count_between = sorted_centers_tree.sum_query(left_boundary, right_boundary);
		sorted_centers_tree.update(jaje[i].second, 1);
		solution += count_between;
	}
	cout << solution << "\n";

	return 0;
}

SegmentTree::SegmentTree(const vector<ll>& elements)
{
	element_cnt = elements.size();
	tree = vector<ll>(2 * element_cnt);
	copy(elements.begin(), elements.end(), tree.begin() + element_cnt);
	for (int i = element_cnt - 1; i >= 0; i--)
	{
		tree[i] = tree[2 * i] + tree[2 * i + 1];
	}
}

ll SegmentTree::sum_query(int l, int r)
{
	l += element_cnt;
	r += element_cnt;
	ll sum = 0;
	while (l < r)
	{
		if (l % 2 == 1)
		{
			sum += tree[l++];
		}
		if (r % 2 == 1)
		{
			sum += tree[--r];
		}
		l /= 2;
		r /= 2;
	}
	return sum;
}

void SegmentTree::update(int pos, ll new_value)
{
	pos += element_cnt;
	tree[pos] = new_value;
	pos /= 2;
	while (pos > 0)
	{
		tree[pos] = tree[2 * pos] + tree[2 * pos + 1];
		pos /= 2;
	}
}