#include <algorithm>
#include <iostream>
#include <vector>
#include <map>
#include <tuple>
using namespace std;
typedef long long ll;

struct var
{
	ll value;
	string var1, var2;
};
bool operator > (const var& lhs, const var& rhs)
{
	return lhs.value > rhs.value;
}

tuple<ll, ll, ll> solve(ll n, ll pz, ll pc, ll zc)
{
	if (pz+pc+zc > 2*n)
	{
		return { -1,-1,-1 };
	}

	map<string, ll> var_values;
	var_values["p"] = -1;
	var_values["z"] = -1;
	var_values["c"] = -1;
	vector<var> values = { {pz,"p","z"},{pc,"p","c"},{zc,"z","c"} };
	sort(values.begin(), values.end(), greater<var>());
	var_values[values[2].var1] = 0;
	var_values[values[2].var2] = values[2].value;

	ll assigned_vars_sum = 0;
	for (auto kvp : var_values)
	{
		if (kvp.second != -1)
		{
			assigned_vars_sum += kvp.second;
		}
	}
	string unassigned_var = "";
	for (auto kvp : var_values)
	{
		if (kvp.second == -1)
		{
			unassigned_var = kvp.first;
		}
	}
	var_values[unassigned_var] = n - assigned_vars_sum;

	return { var_values["c"], var_values["z"], var_values["p"] };
}

int main()
{
	ios::sync_with_stdio(false);
	cin.tie(0);

	ll n, pz, pc, zc;
	cin >> n >> pz >> pc >> zc;
	auto sol = solve(n, pz, pc, zc);
	if (get<0>(sol) == -1)
	{
		cout << "nemoguce\n";
	}
	else
	{
		cout << "moguce\n";
		cout << get<0>(sol) << " " << get<1>(sol) << " " << get<2>(sol) << "\n";
	}

	return 0;
}