#include <iostream>

const int n_cols = 3;

void nemoguce(){
    std::cout << "nemoguce\n";
}

void moguce(){
    std::cout << "moguce\n";
}

int main(){
    int N;
    std::cin >> N;

    int inputs[n_cols];
    for (int i = 0; i < n_cols; i++) std::cin >> inputs[i];

    int global_max = N - (n_cols - 1);

    if (global_max < 1){
        nemoguce();
        return 0;
    }

    int colmaxes[n_cols];
    int sum = 0;
    for (int i = 0; i < n_cols; i++){
        colmaxes[i] = std::min(N - (inputs[i] - 1), global_max);
        sum += colmaxes[i];

        //std::cout << colmaxes[i] << " - ";
    }
    //std::cout << "\n";

    if (sum < N){
        nemoguce();
        return 0;
    }

    moguce();
    for (int i = 0; i < n_cols; i++){
        int ncomp = (i == n_cols - 1) ? N : N - 1;
        if (colmaxes[i] <= ncomp){
            N -= colmaxes[i];
            std::cout << colmaxes[i] << " ";
        }
        else {
            std::cout << ncomp << " ";
            N -= ncomp;
        }
    }

    std::cout << "\n";

    return 0;
}